// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchSecurityTypeExtensions
    {
        public static string ToSerialString(this BatchSecurityType value) => value switch
        {
            BatchSecurityType.TrustedLaunch => "trustedLaunch",
            BatchSecurityType.ConfidentialVm => "confidentialVM",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchSecurityType value.")
        };

        public static BatchSecurityType ToBatchSecurityType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "trustedLaunch")) return BatchSecurityType.TrustedLaunch;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "confidentialVM")) return BatchSecurityType.ConfidentialVm;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchSecurityType value.");
        }
    }
}
