// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> Specifies the EncryptionType of the managed disk. It is set to VMGuestStateOnly for encryption of just the VMGuestState blob, and NonPersistedTPM for not persisting firmware state in the VMGuestState blob. **Note**: It can be set for only Confidential VMs and required when using Confidential VMs. </summary>
    public readonly partial struct BatchSecurityEncryptionType : IEquatable<BatchSecurityEncryptionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchSecurityEncryptionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchSecurityEncryptionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NonPersistedTPMValue = "NonPersistedTPM";
        private const string VmGuestStateOnlyValue = "VMGuestStateOnly";

        /// <summary> NonPersistedTPM. </summary>
        public static BatchSecurityEncryptionType NonPersistedTPM { get; } = new BatchSecurityEncryptionType(NonPersistedTPMValue);
        /// <summary> VMGuestStateOnly. </summary>
        public static BatchSecurityEncryptionType VmGuestStateOnly { get; } = new BatchSecurityEncryptionType(VmGuestStateOnlyValue);
        /// <summary> Determines if two <see cref="BatchSecurityEncryptionType"/> values are the same. </summary>
        public static bool operator ==(BatchSecurityEncryptionType left, BatchSecurityEncryptionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchSecurityEncryptionType"/> values are not the same. </summary>
        public static bool operator !=(BatchSecurityEncryptionType left, BatchSecurityEncryptionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchSecurityEncryptionType"/>. </summary>
        public static implicit operator BatchSecurityEncryptionType(string value) => new BatchSecurityEncryptionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchSecurityEncryptionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchSecurityEncryptionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
