// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> Details of a provisioning issue for a network security perimeter (NSP) configuration. Resource providers should generate separate provisioning issue elements for each separate issue detected, and include a meaningful and distinctive description, as well as any appropriate suggestedResourceIds and suggestedAccessRules. </summary>
    public partial class BatchProvisioningIssueProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchProvisioningIssueProperties"/>. </summary>
        internal BatchProvisioningIssueProperties()
        {
            SuggestedResourceIds = new ChangeTrackingList<ResourceIdentifier>();
            SuggestedAccessRules = new ChangeTrackingList<BatchAccessRule>();
        }

        /// <summary> Initializes a new instance of <see cref="BatchProvisioningIssueProperties"/>. </summary>
        /// <param name="issueType"> Type of issue. </param>
        /// <param name="severity"> Severity of the issue. </param>
        /// <param name="description"> Description of the issue. </param>
        /// <param name="suggestedResourceIds"> Fully qualified resource IDs of suggested resources that can be associated to the network security perimeter (NSP) to remediate the issue. </param>
        /// <param name="suggestedAccessRules"> Access rules that can be added to the network security profile (NSP) to remediate the issue. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchProvisioningIssueProperties(BatchIssueType? issueType, BatchSeverity? severity, string description, IReadOnlyList<ResourceIdentifier> suggestedResourceIds, IReadOnlyList<BatchAccessRule> suggestedAccessRules, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IssueType = issueType;
            Severity = severity;
            Description = description;
            SuggestedResourceIds = suggestedResourceIds;
            SuggestedAccessRules = suggestedAccessRules;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of issue. </summary>
        public BatchIssueType? IssueType { get; }
        /// <summary> Severity of the issue. </summary>
        public BatchSeverity? Severity { get; }
        /// <summary> Description of the issue. </summary>
        public string Description { get; }
        /// <summary> Fully qualified resource IDs of suggested resources that can be associated to the network security perimeter (NSP) to remediate the issue. </summary>
        public IReadOnlyList<ResourceIdentifier> SuggestedResourceIds { get; }
        /// <summary> Access rules that can be added to the network security profile (NSP) to remediate the issue. </summary>
        public IReadOnlyList<BatchAccessRule> SuggestedAccessRules { get; }
    }
}
