// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Batch.Models
{
    public partial class BatchProvisioningIssueProperties : IUtf8JsonSerializable, IJsonModel<BatchProvisioningIssueProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BatchProvisioningIssueProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BatchProvisioningIssueProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchProvisioningIssueProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchProvisioningIssueProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(IssueType))
            {
                writer.WritePropertyName("issueType"u8);
                writer.WriteStringValue(IssueType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(Severity))
            {
                writer.WritePropertyName("severity"u8);
                writer.WriteStringValue(Severity.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SuggestedResourceIds))
            {
                writer.WritePropertyName("suggestedResourceIds"u8);
                writer.WriteStartArray();
                foreach (var item in SuggestedResourceIds)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SuggestedAccessRules))
            {
                writer.WritePropertyName("suggestedAccessRules"u8);
                writer.WriteStartArray();
                foreach (var item in SuggestedAccessRules)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BatchProvisioningIssueProperties IJsonModel<BatchProvisioningIssueProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchProvisioningIssueProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchProvisioningIssueProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBatchProvisioningIssueProperties(document.RootElement, options);
        }

        internal static BatchProvisioningIssueProperties DeserializeBatchProvisioningIssueProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            BatchIssueType? issueType = default;
            BatchSeverity? severity = default;
            string description = default;
            IReadOnlyList<ResourceIdentifier> suggestedResourceIds = default;
            IReadOnlyList<BatchAccessRule> suggestedAccessRules = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("issueType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    issueType = new BatchIssueType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("severity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    severity = new BatchSeverity(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("suggestedResourceIds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResourceIdentifier> array = new List<ResourceIdentifier>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        if (item.ValueKind == JsonValueKind.Null)
                        {
                            array.Add(null);
                        }
                        else
                        {
                            array.Add(new ResourceIdentifier(item.GetString()));
                        }
                    }
                    suggestedResourceIds = array;
                    continue;
                }
                if (property.NameEquals("suggestedAccessRules"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BatchAccessRule> array = new List<BatchAccessRule>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BatchAccessRule.DeserializeBatchAccessRule(item, options));
                    }
                    suggestedAccessRules = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BatchProvisioningIssueProperties(
                issueType,
                severity,
                description,
                suggestedResourceIds ?? new ChangeTrackingList<ResourceIdentifier>(),
                suggestedAccessRules ?? new ChangeTrackingList<BatchAccessRule>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BatchProvisioningIssueProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchProvisioningIssueProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BatchProvisioningIssueProperties)} does not support writing '{options.Format}' format.");
            }
        }

        BatchProvisioningIssueProperties IPersistableModel<BatchProvisioningIssueProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchProvisioningIssueProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBatchProvisioningIssueProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BatchProvisioningIssueProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BatchProvisioningIssueProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
