// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchPrivateLinkServiceConnectionStatusExtensions
    {
        public static string ToSerialString(this BatchPrivateLinkServiceConnectionStatus value) => value switch
        {
            BatchPrivateLinkServiceConnectionStatus.Approved => "Approved",
            BatchPrivateLinkServiceConnectionStatus.Pending => "Pending",
            BatchPrivateLinkServiceConnectionStatus.Rejected => "Rejected",
            BatchPrivateLinkServiceConnectionStatus.Disconnected => "Disconnected",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchPrivateLinkServiceConnectionStatus value.")
        };

        public static BatchPrivateLinkServiceConnectionStatus ToBatchPrivateLinkServiceConnectionStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Approved")) return BatchPrivateLinkServiceConnectionStatus.Approved;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Pending")) return BatchPrivateLinkServiceConnectionStatus.Pending;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Rejected")) return BatchPrivateLinkServiceConnectionStatus.Rejected;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disconnected")) return BatchPrivateLinkServiceConnectionStatus.Disconnected;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchPrivateLinkServiceConnectionStatus value.");
        }
    }
}
