// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchNodePlacementPolicyTypeExtensions
    {
        public static string ToSerialString(this BatchNodePlacementPolicyType value) => value switch
        {
            BatchNodePlacementPolicyType.Regional => "Regional",
            BatchNodePlacementPolicyType.Zonal => "Zonal",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchNodePlacementPolicyType value.")
        };

        public static BatchNodePlacementPolicyType ToBatchNodePlacementPolicyType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Regional")) return BatchNodePlacementPolicyType.Regional;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Zonal")) return BatchNodePlacementPolicyType.Zonal;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchNodePlacementPolicyType value.");
        }
    }
}
