// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchNodeFillTypeExtensions
    {
        public static string ToSerialString(this BatchNodeFillType value) => value switch
        {
            BatchNodeFillType.Spread => "Spread",
            BatchNodeFillType.Pack => "Pack",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchNodeFillType value.")
        };

        public static BatchNodeFillType ToBatchNodeFillType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Spread")) return BatchNodeFillType.Spread;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Pack")) return BatchNodeFillType.Pack;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchNodeFillType value.");
        }
    }
}
