// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> Determines what to do with a node and its running task(s) after it has been selected for deallocation. </summary>
    public enum BatchNodeDeallocationOption
    {
        /// <summary> Terminate running task processes and requeue the tasks. The tasks will run again when a node is available. Remove nodes as soon as tasks have been terminated. </summary>
        Requeue,
        /// <summary> Terminate running tasks. The tasks will be completed with failureInfo indicating that they were terminated, and will not run again. Remove nodes as soon as tasks have been terminated. </summary>
        Terminate,
        /// <summary> Allow currently running tasks to complete. Schedule no new tasks while waiting. Remove nodes when all tasks have completed. </summary>
        TaskCompletion,
        /// <summary> Allow currently running tasks to complete, then wait for all task data retention periods to expire. Schedule no new tasks while waiting. Remove nodes when all task retention periods have expired. </summary>
        RetainedData
    }
}
