// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchNetworkSecurityGroupRuleAccessExtensions
    {
        public static string ToSerialString(this BatchNetworkSecurityGroupRuleAccess value) => value switch
        {
            BatchNetworkSecurityGroupRuleAccess.Allow => "Allow",
            BatchNetworkSecurityGroupRuleAccess.Deny => "Deny",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchNetworkSecurityGroupRuleAccess value.")
        };

        public static BatchNetworkSecurityGroupRuleAccess ToBatchNetworkSecurityGroupRuleAccess(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Allow")) return BatchNetworkSecurityGroupRuleAccess.Allow;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Deny")) return BatchNetworkSecurityGroupRuleAccess.Deny;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchNetworkSecurityGroupRuleAccess value.");
        }
    }
}
