// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> Network profile for Batch account, which contains network rule settings for each endpoint. </summary>
    public partial class BatchNetworkProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchNetworkProfile"/>. </summary>
        public BatchNetworkProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BatchNetworkProfile"/>. </summary>
        /// <param name="accountAccess"> Network access profile for batchAccount endpoint (Batch account data plane API). </param>
        /// <param name="nodeManagementAccess"> Network access profile for nodeManagement endpoint (Batch service managing compute nodes for Batch pools). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchNetworkProfile(BatchEndpointAccessProfile accountAccess, BatchEndpointAccessProfile nodeManagementAccess, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AccountAccess = accountAccess;
            NodeManagementAccess = nodeManagementAccess;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Network access profile for batchAccount endpoint (Batch account data plane API). </summary>
        public BatchEndpointAccessProfile AccountAccess { get; set; }
        /// <summary> Network access profile for nodeManagement endpoint (Batch service managing compute nodes for Batch pools). </summary>
        public BatchEndpointAccessProfile NodeManagementAccess { get; set; }
    }
}
