// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> Identifies the Azure key vault associated with a Batch account. </summary>
    public partial class BatchKeyVaultReference
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchKeyVaultReference"/>. </summary>
        /// <param name="id"> The resource ID of the Azure key vault associated with the Batch account. </param>
        /// <param name="uri"> The URL of the Azure key vault associated with the Batch account. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="uri"/> is null. </exception>
        public BatchKeyVaultReference(ResourceIdentifier id, Uri uri)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(uri, nameof(uri));

            Id = id;
            Uri = uri;
        }

        /// <summary> Initializes a new instance of <see cref="BatchKeyVaultReference"/>. </summary>
        /// <param name="id"> The resource ID of the Azure key vault associated with the Batch account. </param>
        /// <param name="uri"> The URL of the Azure key vault associated with the Batch account. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchKeyVaultReference(ResourceIdentifier id, Uri uri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Uri = uri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BatchKeyVaultReference"/> for deserialization. </summary>
        internal BatchKeyVaultReference()
        {
        }

        /// <summary> The resource ID of the Azure key vault associated with the Batch account. </summary>
        public ResourceIdentifier Id { get; set; }
        /// <summary> The URL of the Azure key vault associated with the Batch account. </summary>
        public Uri Uri { get; set; }
    }
}
