// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Batch.Models
{
    public partial class BatchInboundNatPool : IUtf8JsonSerializable, IJsonModel<BatchInboundNatPool>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BatchInboundNatPool>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BatchInboundNatPool>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchInboundNatPool>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchInboundNatPool)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("name"u8);
            writer.WriteStringValue(Name);
            writer.WritePropertyName("protocol"u8);
            writer.WriteStringValue(Protocol.ToSerialString());
            writer.WritePropertyName("backendPort"u8);
            writer.WriteNumberValue(BackendPort);
            writer.WritePropertyName("frontendPortRangeStart"u8);
            writer.WriteNumberValue(FrontendPortRangeStart);
            writer.WritePropertyName("frontendPortRangeEnd"u8);
            writer.WriteNumberValue(FrontendPortRangeEnd);
            if (Optional.IsCollectionDefined(NetworkSecurityGroupRules))
            {
                writer.WritePropertyName("networkSecurityGroupRules"u8);
                writer.WriteStartArray();
                foreach (var item in NetworkSecurityGroupRules)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BatchInboundNatPool IJsonModel<BatchInboundNatPool>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchInboundNatPool>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchInboundNatPool)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBatchInboundNatPool(document.RootElement, options);
        }

        internal static BatchInboundNatPool DeserializeBatchInboundNatPool(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            BatchInboundEndpointProtocol protocol = default;
            int backendPort = default;
            int frontendPortRangeStart = default;
            int frontendPortRangeEnd = default;
            IList<BatchNetworkSecurityGroupRule> networkSecurityGroupRules = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("protocol"u8))
                {
                    protocol = property.Value.GetString().ToBatchInboundEndpointProtocol();
                    continue;
                }
                if (property.NameEquals("backendPort"u8))
                {
                    backendPort = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("frontendPortRangeStart"u8))
                {
                    frontendPortRangeStart = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("frontendPortRangeEnd"u8))
                {
                    frontendPortRangeEnd = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("networkSecurityGroupRules"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BatchNetworkSecurityGroupRule> array = new List<BatchNetworkSecurityGroupRule>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BatchNetworkSecurityGroupRule.DeserializeBatchNetworkSecurityGroupRule(item, options));
                    }
                    networkSecurityGroupRules = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BatchInboundNatPool(
                name,
                protocol,
                backendPort,
                frontendPortRangeStart,
                frontendPortRangeEnd,
                networkSecurityGroupRules ?? new ChangeTrackingList<BatchNetworkSecurityGroupRule>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BatchInboundNatPool>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchInboundNatPool>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BatchInboundNatPool)} does not support writing '{options.Format}' format.");
            }
        }

        BatchInboundNatPool IPersistableModel<BatchInboundNatPool>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchInboundNatPool>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBatchInboundNatPool(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BatchInboundNatPool)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BatchInboundNatPool>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
