// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchInboundEndpointProtocolExtensions
    {
        public static string ToSerialString(this BatchInboundEndpointProtocol value) => value switch
        {
            BatchInboundEndpointProtocol.Tcp => "TCP",
            BatchInboundEndpointProtocol.Udp => "UDP",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchInboundEndpointProtocol value.")
        };

        public static BatchInboundEndpointProtocol ToBatchInboundEndpointProtocol(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "TCP")) return BatchInboundEndpointProtocol.Tcp;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "UDP")) return BatchInboundEndpointProtocol.Udp;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchInboundEndpointProtocol value.");
        }
    }
}
