// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> Action when client IP address is matched. </summary>
    public readonly partial struct BatchIPRuleAction : IEquatable<BatchIPRuleAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchIPRuleAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchIPRuleAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";

        /// <summary> Allow. </summary>
        public static BatchIPRuleAction Allow { get; } = new BatchIPRuleAction(AllowValue);
        /// <summary> Determines if two <see cref="BatchIPRuleAction"/> values are the same. </summary>
        public static bool operator ==(BatchIPRuleAction left, BatchIPRuleAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchIPRuleAction"/> values are not the same. </summary>
        public static bool operator !=(BatchIPRuleAction left, BatchIPRuleAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchIPRuleAction"/>. </summary>
        public static implicit operator BatchIPRuleAction(string value) => new BatchIPRuleAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchIPRuleAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchIPRuleAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
