// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> Rule to filter client IP address. </summary>
    public partial class BatchIPRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchIPRule"/>. </summary>
        /// <param name="value"> IPv4 address, or IPv4 address range in CIDR format. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchIPRule(string value)
        {
            Argument.AssertNotNull(value, nameof(value));

            Action = BatchIPRuleAction.Allow;
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="BatchIPRule"/>. </summary>
        /// <param name="action"> Action when client IP address is matched. </param>
        /// <param name="value"> IPv4 address, or IPv4 address range in CIDR format. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchIPRule(BatchIPRuleAction action, string value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Action = action;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BatchIPRule"/> for deserialization. </summary>
        internal BatchIPRule()
        {
        }
        /// <summary> IPv4 address, or IPv4 address range in CIDR format. </summary>
        public string Value { get; set; }
    }
}
