// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchIPAddressProvisioningTypeExtensions
    {
        public static string ToSerialString(this BatchIPAddressProvisioningType value) => value switch
        {
            BatchIPAddressProvisioningType.BatchManaged => "BatchManaged",
            BatchIPAddressProvisioningType.UserManaged => "UserManaged",
            BatchIPAddressProvisioningType.NoPublicIPAddresses => "NoPublicIPAddresses",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchIPAddressProvisioningType value.")
        };

        public static BatchIPAddressProvisioningType ToBatchIPAddressProvisioningType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "BatchManaged")) return BatchIPAddressProvisioningType.BatchManaged;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "UserManaged")) return BatchIPAddressProvisioningType.UserManaged;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NoPublicIPAddresses")) return BatchIPAddressProvisioningType.NoPublicIPAddresses;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchIPAddressProvisioningType value.");
        }
    }
}
