// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchEndpointAccessDefaultActionExtensions
    {
        public static string ToSerialString(this BatchEndpointAccessDefaultAction value) => value switch
        {
            BatchEndpointAccessDefaultAction.Allow => "Allow",
            BatchEndpointAccessDefaultAction.Deny => "Deny",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchEndpointAccessDefaultAction value.")
        };

        public static BatchEndpointAccessDefaultAction ToBatchEndpointAccessDefaultAction(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Allow")) return BatchEndpointAccessDefaultAction.Allow;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Deny")) return BatchEndpointAccessDefaultAction.Deny;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchEndpointAccessDefaultAction value.");
        }
    }
}
