// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchContainerWorkingDirectoryExtensions
    {
        public static string ToSerialString(this BatchContainerWorkingDirectory value) => value switch
        {
            BatchContainerWorkingDirectory.TaskWorkingDirectory => "TaskWorkingDirectory",
            BatchContainerWorkingDirectory.ContainerImageDefault => "ContainerImageDefault",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchContainerWorkingDirectory value.")
        };

        public static BatchContainerWorkingDirectory ToBatchContainerWorkingDirectory(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "TaskWorkingDirectory")) return BatchContainerWorkingDirectory.TaskWorkingDirectory;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ContainerImageDefault")) return BatchContainerWorkingDirectory.ContainerImageDefault;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchContainerWorkingDirectory value.");
        }
    }
}
