// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchCertificateVisibilityExtensions
    {
        public static string ToSerialString(this BatchCertificateVisibility value) => value switch
        {
            BatchCertificateVisibility.StartTask => "StartTask",
            BatchCertificateVisibility.Task => "Task",
            BatchCertificateVisibility.RemoteUser => "RemoteUser",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchCertificateVisibility value.")
        };

        public static BatchCertificateVisibility ToBatchCertificateVisibility(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "StartTask")) return BatchCertificateVisibility.StartTask;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Task")) return BatchCertificateVisibility.Task;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RemoteUser")) return BatchCertificateVisibility.RemoteUser;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchCertificateVisibility value.");
        }
    }
}
