// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> The default value is currentUser. This property is applicable only for pools configured with Windows compute nodes. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory. </summary>
    public enum BatchCertificateStoreLocation
    {
        /// <summary> Certificates should be installed to the CurrentUser certificate store. </summary>
        CurrentUser,
        /// <summary> Certificates should be installed to the LocalMachine certificate store. </summary>
        LocalMachine
    }
}
