// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchCertificateStoreLocationExtensions
    {
        public static string ToSerialString(this BatchCertificateStoreLocation value) => value switch
        {
            BatchCertificateStoreLocation.CurrentUser => "CurrentUser",
            BatchCertificateStoreLocation.LocalMachine => "LocalMachine",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchCertificateStoreLocation value.")
        };

        public static BatchCertificateStoreLocation ToBatchCertificateStoreLocation(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "CurrentUser")) return BatchCertificateStoreLocation.CurrentUser;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "LocalMachine")) return BatchCertificateStoreLocation.LocalMachine;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchCertificateStoreLocation value.");
        }
    }
}
