// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchAutoUserScopeExtensions
    {
        public static string ToSerialString(this BatchAutoUserScope value) => value switch
        {
            BatchAutoUserScope.Task => "Task",
            BatchAutoUserScope.Pool => "Pool",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchAutoUserScope value.")
        };

        public static BatchAutoUserScope ToBatchAutoUserScope(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Task")) return BatchAutoUserScope.Task;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Pool")) return BatchAutoUserScope.Pool;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchAutoUserScope value.");
        }
    }
}
