// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchAutoStorageAuthenticationModeExtensions
    {
        public static string ToSerialString(this BatchAutoStorageAuthenticationMode value) => value switch
        {
            BatchAutoStorageAuthenticationMode.StorageKeys => "StorageKeys",
            BatchAutoStorageAuthenticationMode.BatchAccountManagedIdentity => "BatchAccountManagedIdentity",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchAutoStorageAuthenticationMode value.")
        };

        public static BatchAutoStorageAuthenticationMode ToBatchAutoStorageAuthenticationMode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "StorageKeys")) return BatchAutoStorageAuthenticationMode.StorageKeys;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "BatchAccountManagedIdentity")) return BatchAutoStorageAuthenticationMode.BatchAccountManagedIdentity;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchAutoStorageAuthenticationMode value.");
        }
    }
}
