// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchApplicationPackageStateExtensions
    {
        public static string ToSerialString(this BatchApplicationPackageState value) => value switch
        {
            BatchApplicationPackageState.Pending => "Pending",
            BatchApplicationPackageState.Active => "Active",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchApplicationPackageState value.")
        };

        public static BatchApplicationPackageState ToBatchApplicationPackageState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Pending")) return BatchApplicationPackageState.Pending;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Active")) return BatchApplicationPackageState.Active;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchApplicationPackageState value.");
        }
    }
}
