// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> Parameters for an activating an application package. </summary>
    public partial class BatchApplicationPackageActivateContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchApplicationPackageActivateContent"/>. </summary>
        /// <param name="format"> The format of the application package binary file. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="format"/> is null. </exception>
        public BatchApplicationPackageActivateContent(string format)
        {
            Argument.AssertNotNull(format, nameof(format));

            Format = format;
        }

        /// <summary> Initializes a new instance of <see cref="BatchApplicationPackageActivateContent"/>. </summary>
        /// <param name="format"> The format of the application package binary file. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchApplicationPackageActivateContent(string format, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Format = format;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BatchApplicationPackageActivateContent"/> for deserialization. </summary>
        internal BatchApplicationPackageActivateContent()
        {
        }

        /// <summary> The format of the application package binary file. </summary>
        public string Format { get; }
    }
}
