// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes. </summary>
    public partial class BatchAccountPoolScaleSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchAccountPoolScaleSettings"/>. </summary>
        public BatchAccountPoolScaleSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BatchAccountPoolScaleSettings"/>. </summary>
        /// <param name="fixedScale"> This property and autoScale are mutually exclusive and one of the properties must be specified. </param>
        /// <param name="autoScale"> This property and fixedScale are mutually exclusive and one of the properties must be specified. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchAccountPoolScaleSettings(BatchAccountFixedScaleSettings fixedScale, BatchAccountAutoScaleSettings autoScale, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FixedScale = fixedScale;
            AutoScale = autoScale;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> This property and autoScale are mutually exclusive and one of the properties must be specified. </summary>
        public BatchAccountFixedScaleSettings FixedScale { get; set; }
        /// <summary> This property and fixedScale are mutually exclusive and one of the properties must be specified. </summary>
        public BatchAccountAutoScaleSettings AutoScale { get; set; }
    }
}
