// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> The current state of the pool. </summary>
    public readonly partial struct BatchAccountPoolProvisioningState : IEquatable<BatchAccountPoolProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchAccountPoolProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchAccountPoolProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string DeletingValue = "Deleting";

        /// <summary> The pool is available to run tasks subject to the availability of compute nodes. </summary>
        public static BatchAccountPoolProvisioningState Succeeded { get; } = new BatchAccountPoolProvisioningState(SucceededValue);
        /// <summary> The user has requested that the pool be deleted, but the delete operation has not yet completed. </summary>
        public static BatchAccountPoolProvisioningState Deleting { get; } = new BatchAccountPoolProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="BatchAccountPoolProvisioningState"/> values are the same. </summary>
        public static bool operator ==(BatchAccountPoolProvisioningState left, BatchAccountPoolProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchAccountPoolProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(BatchAccountPoolProvisioningState left, BatchAccountPoolProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchAccountPoolProvisioningState"/>. </summary>
        public static implicit operator BatchAccountPoolProvisioningState(string value) => new BatchAccountPoolProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchAccountPoolProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchAccountPoolProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
