// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> Whether the pool is resizing. </summary>
    public enum BatchAccountPoolAllocationState
    {
        /// <summary> The pool is not resizing. There are no changes to the number of nodes in the pool in progress. A pool enters this state when it is created and when no operations are being performed on the pool to change the number of nodes. </summary>
        Steady,
        /// <summary> The pool is resizing; that is, compute nodes are being added to or removed from the pool. </summary>
        Resizing,
        /// <summary> The pool was resizing, but the user has requested that the resize be stopped, but the stop request has not yet been completed. </summary>
        Stopping
    }
}
