// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchAccountPoolAllocationModeExtensions
    {
        public static string ToSerialString(this BatchAccountPoolAllocationMode value) => value switch
        {
            BatchAccountPoolAllocationMode.BatchService => "BatchService",
            BatchAccountPoolAllocationMode.UserSubscription => "UserSubscription",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchAccountPoolAllocationMode value.")
        };

        public static BatchAccountPoolAllocationMode ToBatchAccountPoolAllocationMode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "BatchService")) return BatchAccountPoolAllocationMode.BatchService;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "UserSubscription")) return BatchAccountPoolAllocationMode.UserSubscription;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchAccountPoolAllocationMode value.");
        }
    }
}
