// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> Parameters for updating an Azure Batch account. </summary>
    public partial class BatchAccountPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchAccountPatch"/>. </summary>
        public BatchAccountPatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
            AllowedAuthenticationModes = new ChangeTrackingList<BatchAuthenticationMode>();
        }

        /// <summary> Initializes a new instance of <see cref="BatchAccountPatch"/>. </summary>
        /// <param name="tags"> The user-specified tags associated with the account. </param>
        /// <param name="identity"> The identity of the Batch account. Current supported identity types: None, SystemAssigned, UserAssigned. </param>
        /// <param name="autoStorage"> The properties related to the auto-storage account. </param>
        /// <param name="encryption"> Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead. </param>
        /// <param name="allowedAuthenticationModes"> List of allowed authentication modes for the Batch account that can be used to authenticate with the data plane. This does not affect authentication with the control plane. </param>
        /// <param name="publicNetworkAccess"> If not specified, the default value is 'enabled'. </param>
        /// <param name="networkProfile"> The network profile only takes effect when publicNetworkAccess is enabled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchAccountPatch(IDictionary<string, string> tags, ManagedServiceIdentity identity, BatchAccountAutoStorageBaseConfiguration autoStorage, BatchAccountEncryptionConfiguration encryption, IList<BatchAuthenticationMode> allowedAuthenticationModes, BatchPublicNetworkAccess? publicNetworkAccess, BatchNetworkProfile networkProfile, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tags = tags;
            Identity = identity;
            AutoStorage = autoStorage;
            Encryption = encryption;
            AllowedAuthenticationModes = allowedAuthenticationModes;
            PublicNetworkAccess = publicNetworkAccess;
            NetworkProfile = networkProfile;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The user-specified tags associated with the account. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> The identity of the Batch account. Current supported identity types: None, SystemAssigned, UserAssigned. </summary>
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> The properties related to the auto-storage account. </summary>
        public BatchAccountAutoStorageBaseConfiguration AutoStorage { get; set; }
        /// <summary> Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead. </summary>
        public BatchAccountEncryptionConfiguration Encryption { get; set; }
        /// <summary> List of allowed authentication modes for the Batch account that can be used to authenticate with the data plane. This does not affect authentication with the control plane. </summary>
        public IList<BatchAuthenticationMode> AllowedAuthenticationModes { get; set; }
        /// <summary> If not specified, the default value is 'enabled'. </summary>
        public BatchPublicNetworkAccess? PublicNetworkAccess { get; set; }
        /// <summary> The network profile only takes effect when publicNetworkAccess is enabled. </summary>
        public BatchNetworkProfile NetworkProfile { get; set; }
    }
}
