// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> A set of Azure Batch account keys. </summary>
    public partial class BatchAccountKeys
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchAccountKeys"/>. </summary>
        internal BatchAccountKeys()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BatchAccountKeys"/>. </summary>
        /// <param name="accountName"> The Batch account name. </param>
        /// <param name="primary"> The primary key associated with the account. </param>
        /// <param name="secondary"> The secondary key associated with the account. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchAccountKeys(string accountName, string primary, string secondary, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AccountName = accountName;
            Primary = primary;
            Secondary = secondary;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Batch account name. </summary>
        public string AccountName { get; }
        /// <summary> The primary key associated with the account. </summary>
        public string Primary { get; }
        /// <summary> The secondary key associated with the account. </summary>
        public string Secondary { get; }
    }
}
