// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchAccountKeyTypeExtensions
    {
        public static string ToSerialString(this BatchAccountKeyType value) => value switch
        {
            BatchAccountKeyType.Primary => "Primary",
            BatchAccountKeyType.Secondary => "Secondary",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchAccountKeyType value.")
        };

        public static BatchAccountKeyType ToBatchAccountKeyType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Primary")) return BatchAccountKeyType.Primary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Secondary")) return BatchAccountKeyType.Secondary;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchAccountKeyType value.");
        }
    }
}
