// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchAccountKeySourceExtensions
    {
        public static string ToSerialString(this BatchAccountKeySource value) => value switch
        {
            BatchAccountKeySource.MicrosoftBatch => "Microsoft.Batch",
            BatchAccountKeySource.MicrosoftKeyVault => "Microsoft.KeyVault",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchAccountKeySource value.")
        };

        public static BatchAccountKeySource ToBatchAccountKeySource(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Microsoft.Batch")) return BatchAccountKeySource.MicrosoftBatch;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Microsoft.KeyVault")) return BatchAccountKeySource.MicrosoftKeyVault;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchAccountKeySource value.");
        }
    }
}
