// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Batch.Models
{
    internal static partial class BatchAccountCertificateFormatExtensions
    {
        public static string ToSerialString(this BatchAccountCertificateFormat value) => value switch
        {
            BatchAccountCertificateFormat.Pfx => "Pfx",
            BatchAccountCertificateFormat.Cer => "Cer",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchAccountCertificateFormat value.")
        };

        public static BatchAccountCertificateFormat ToBatchAccountCertificateFormat(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Pfx")) return BatchAccountCertificateFormat.Pfx;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Cer")) return BatchAccountCertificateFormat.Cer;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BatchAccountCertificateFormat value.");
        }
    }
}
