// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Batch.Models
{
    /// <summary> Direction of Access Rule. </summary>
    public readonly partial struct BatchAccessRuleDirection : IEquatable<BatchAccessRuleDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchAccessRuleDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchAccessRuleDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InboundValue = "Inbound";
        private const string OutboundValue = "Outbound";

        /// <summary> Applies to inbound network traffic to the secured resources. </summary>
        public static BatchAccessRuleDirection Inbound { get; } = new BatchAccessRuleDirection(InboundValue);
        /// <summary> Applies to outbound network traffic from the secured resources. </summary>
        public static BatchAccessRuleDirection Outbound { get; } = new BatchAccessRuleDirection(OutboundValue);
        /// <summary> Determines if two <see cref="BatchAccessRuleDirection"/> values are the same. </summary>
        public static bool operator ==(BatchAccessRuleDirection left, BatchAccessRuleDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchAccessRuleDirection"/> values are not the same. </summary>
        public static bool operator !=(BatchAccessRuleDirection left, BatchAccessRuleDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchAccessRuleDirection"/>. </summary>
        public static implicit operator BatchAccessRuleDirection(string value) => new BatchAccessRuleDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchAccessRuleDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchAccessRuleDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
