// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Batch.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Batch
{
    public partial class BatchAccountData : IUtf8JsonSerializable, IJsonModel<BatchAccountData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BatchAccountData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BatchAccountData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchAccountData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchAccountData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Identity))
            {
                writer.WritePropertyName("identity"u8);
                JsonSerializer.Serialize(writer, Identity);
            }
            if (options.Format != "W" && Optional.IsDefined(Location))
            {
                writer.WritePropertyName("location"u8);
                writer.WriteStringValue(Location.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(AccountEndpoint))
            {
                writer.WritePropertyName("accountEndpoint"u8);
                writer.WriteStringValue(AccountEndpoint);
            }
            if (options.Format != "W" && Optional.IsDefined(NodeManagementEndpoint))
            {
                writer.WritePropertyName("nodeManagementEndpoint"u8);
                writer.WriteStringValue(NodeManagementEndpoint);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(PoolAllocationMode))
            {
                writer.WritePropertyName("poolAllocationMode"u8);
                writer.WriteStringValue(PoolAllocationMode.Value.ToSerialString());
            }
            if (options.Format != "W" && Optional.IsDefined(KeyVaultReference))
            {
                writer.WritePropertyName("keyVaultReference"u8);
                writer.WriteObjectValue(KeyVaultReference, options);
            }
            if (Optional.IsDefined(PublicNetworkAccess))
            {
                if (PublicNetworkAccess != null)
                {
                    writer.WritePropertyName("publicNetworkAccess"u8);
                    writer.WriteStringValue(PublicNetworkAccess.Value.ToSerialString());
                }
                else
                {
                    writer.WriteNull("publicNetworkAccess");
                }
            }
            if (Optional.IsDefined(NetworkProfile))
            {
                if (NetworkProfile != null)
                {
                    writer.WritePropertyName("networkProfile"u8);
                    writer.WriteObjectValue(NetworkProfile, options);
                }
                else
                {
                    writer.WriteNull("networkProfile");
                }
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(PrivateEndpointConnections))
            {
                if (PrivateEndpointConnections != null)
                {
                    writer.WritePropertyName("privateEndpointConnections"u8);
                    writer.WriteStartArray();
                    foreach (var item in PrivateEndpointConnections)
                    {
                        writer.WriteObjectValue(item, options);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("privateEndpointConnections");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(AutoStorage))
            {
                writer.WritePropertyName("autoStorage"u8);
                writer.WriteObjectValue(AutoStorage, options);
            }
            if (options.Format != "W" && Optional.IsDefined(Encryption))
            {
                writer.WritePropertyName("encryption"u8);
                writer.WriteObjectValue(Encryption, options);
            }
            if (options.Format != "W" && Optional.IsDefined(DedicatedCoreQuota))
            {
                if (DedicatedCoreQuota != null)
                {
                    writer.WritePropertyName("dedicatedCoreQuota"u8);
                    writer.WriteNumberValue(DedicatedCoreQuota.Value);
                }
                else
                {
                    writer.WriteNull("dedicatedCoreQuota");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(LowPriorityCoreQuota))
            {
                if (LowPriorityCoreQuota != null)
                {
                    writer.WritePropertyName("lowPriorityCoreQuota"u8);
                    writer.WriteNumberValue(LowPriorityCoreQuota.Value);
                }
                else
                {
                    writer.WriteNull("lowPriorityCoreQuota");
                }
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(DedicatedCoreQuotaPerVmFamily))
            {
                if (DedicatedCoreQuotaPerVmFamily != null)
                {
                    writer.WritePropertyName("dedicatedCoreQuotaPerVMFamily"u8);
                    writer.WriteStartArray();
                    foreach (var item in DedicatedCoreQuotaPerVmFamily)
                    {
                        writer.WriteObjectValue(item, options);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("dedicatedCoreQuotaPerVMFamily");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(IsDedicatedCoreQuotaPerVmFamilyEnforced))
            {
                writer.WritePropertyName("dedicatedCoreQuotaPerVMFamilyEnforced"u8);
                writer.WriteBooleanValue(IsDedicatedCoreQuotaPerVmFamilyEnforced.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(PoolQuota))
            {
                writer.WritePropertyName("poolQuota"u8);
                writer.WriteNumberValue(PoolQuota.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ActiveJobAndJobScheduleQuota))
            {
                writer.WritePropertyName("activeJobAndJobScheduleQuota"u8);
                writer.WriteNumberValue(ActiveJobAndJobScheduleQuota.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(AllowedAuthenticationModes))
            {
                if (AllowedAuthenticationModes != null)
                {
                    writer.WritePropertyName("allowedAuthenticationModes"u8);
                    writer.WriteStartArray();
                    foreach (var item in AllowedAuthenticationModes)
                    {
                        writer.WriteStringValue(item.ToSerialString());
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("allowedAuthenticationModes");
                }
            }
            writer.WriteEndObject();
        }

        BatchAccountData IJsonModel<BatchAccountData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchAccountData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchAccountData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBatchAccountData(document.RootElement, options);
        }

        internal static BatchAccountData DeserializeBatchAccountData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ManagedServiceIdentity identity = default;
            AzureLocation? location = default;
            IReadOnlyDictionary<string, string> tags = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string accountEndpoint = default;
            string nodeManagementEndpoint = default;
            BatchProvisioningState? provisioningState = default;
            BatchAccountPoolAllocationMode? poolAllocationMode = default;
            BatchKeyVaultReference keyVaultReference = default;
            BatchPublicNetworkAccess? publicNetworkAccess = default;
            BatchNetworkProfile networkProfile = default;
            IReadOnlyList<BatchPrivateEndpointConnectionData> privateEndpointConnections = default;
            BatchAccountAutoStorageConfiguration autoStorage = default;
            BatchAccountEncryptionConfiguration encryption = default;
            int? dedicatedCoreQuota = default;
            int? lowPriorityCoreQuota = default;
            IReadOnlyList<BatchVmFamilyCoreQuota> dedicatedCoreQuotaPerVmFamily = default;
            bool? dedicatedCoreQuotaPerVmFamilyEnforced = default;
            int? poolQuota = default;
            int? activeJobAndJobScheduleQuota = default;
            IReadOnlyList<BatchAuthenticationMode> allowedAuthenticationModes = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identity = JsonSerializer.Deserialize<ManagedServiceIdentity>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("accountEndpoint"u8))
                        {
                            accountEndpoint = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("nodeManagementEndpoint"u8))
                        {
                            nodeManagementEndpoint = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new BatchProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("poolAllocationMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            poolAllocationMode = property0.Value.GetString().ToBatchAccountPoolAllocationMode();
                            continue;
                        }
                        if (property0.NameEquals("keyVaultReference"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            keyVaultReference = BatchKeyVaultReference.DeserializeBatchKeyVaultReference(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("publicNetworkAccess"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                publicNetworkAccess = null;
                                continue;
                            }
                            publicNetworkAccess = property0.Value.GetString().ToBatchPublicNetworkAccess();
                            continue;
                        }
                        if (property0.NameEquals("networkProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                networkProfile = null;
                                continue;
                            }
                            networkProfile = BatchNetworkProfile.DeserializeBatchNetworkProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("privateEndpointConnections"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                privateEndpointConnections = null;
                                continue;
                            }
                            List<BatchPrivateEndpointConnectionData> array = new List<BatchPrivateEndpointConnectionData>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(BatchPrivateEndpointConnectionData.DeserializeBatchPrivateEndpointConnectionData(item, options));
                            }
                            privateEndpointConnections = array;
                            continue;
                        }
                        if (property0.NameEquals("autoStorage"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            autoStorage = BatchAccountAutoStorageConfiguration.DeserializeBatchAccountAutoStorageConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("encryption"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            encryption = BatchAccountEncryptionConfiguration.DeserializeBatchAccountEncryptionConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("dedicatedCoreQuota"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                dedicatedCoreQuota = null;
                                continue;
                            }
                            dedicatedCoreQuota = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("lowPriorityCoreQuota"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                lowPriorityCoreQuota = null;
                                continue;
                            }
                            lowPriorityCoreQuota = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("dedicatedCoreQuotaPerVMFamily"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                dedicatedCoreQuotaPerVmFamily = null;
                                continue;
                            }
                            List<BatchVmFamilyCoreQuota> array = new List<BatchVmFamilyCoreQuota>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(BatchVmFamilyCoreQuota.DeserializeBatchVmFamilyCoreQuota(item, options));
                            }
                            dedicatedCoreQuotaPerVmFamily = array;
                            continue;
                        }
                        if (property0.NameEquals("dedicatedCoreQuotaPerVMFamilyEnforced"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            dedicatedCoreQuotaPerVmFamilyEnforced = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("poolQuota"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            poolQuota = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("activeJobAndJobScheduleQuota"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            activeJobAndJobScheduleQuota = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("allowedAuthenticationModes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                allowedAuthenticationModes = null;
                                continue;
                            }
                            List<BatchAuthenticationMode> array = new List<BatchAuthenticationMode>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString().ToBatchAuthenticationMode());
                            }
                            allowedAuthenticationModes = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BatchAccountData(
                id,
                name,
                type,
                systemData,
                identity,
                accountEndpoint,
                nodeManagementEndpoint,
                provisioningState,
                poolAllocationMode,
                keyVaultReference,
                publicNetworkAccess,
                networkProfile,
                privateEndpointConnections ?? new ChangeTrackingList<BatchPrivateEndpointConnectionData>(),
                autoStorage,
                encryption,
                dedicatedCoreQuota,
                lowPriorityCoreQuota,
                dedicatedCoreQuotaPerVmFamily ?? new ChangeTrackingList<BatchVmFamilyCoreQuota>(),
                dedicatedCoreQuotaPerVmFamilyEnforced,
                poolQuota,
                activeJobAndJobScheduleQuota,
                allowedAuthenticationModes ?? new ChangeTrackingList<BatchAuthenticationMode>(),
                location,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BatchAccountData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchAccountData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BatchAccountData)} does not support writing '{options.Format}' format.");
            }
        }

        BatchAccountData IPersistableModel<BatchAccountData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchAccountData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBatchAccountData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BatchAccountData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BatchAccountData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
