// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Batch.Samples
{
    public partial class Sample_BatchAccountDetectorResource
    {
        // GetDetector
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDetector()
        {
            // Generated from example definition: specification/batch/resource-manager/Microsoft.Batch/stable/2024-07-01/examples/DetectorGet.json
            // this example is just showing the usage of "BatchAccount_GetDetector" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BatchAccountDetectorResource created on azure
            // for more information of creating BatchAccountDetectorResource, please refer to the document of BatchAccountDetectorResource
            string subscriptionId = "subid";
            string resourceGroupName = "default-azurebatch-japaneast";
            string accountName = "sampleacct";
            string detectorId = "poolsAndNodes";
            ResourceIdentifier batchAccountDetectorResourceId = BatchAccountDetectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, detectorId);
            BatchAccountDetectorResource batchAccountDetector = client.GetBatchAccountDetectorResource(batchAccountDetectorResourceId);

            // invoke the operation
            BatchAccountDetectorResource result = await batchAccountDetector.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BatchAccountDetectorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
