// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using System.Xml;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Compute.Batch.Samples
{
    public partial class Samples_BatchClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetApplication_GetApplications()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetApplication("my_application_id", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("versions")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetApplication_GetApplications_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetApplicationAsync("my_application_id", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("displayName").ToString());
            Console.WriteLine(result.GetProperty("versions")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetApplication_GetApplications_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchApplication> response = client.GetApplication("my_application_id");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetApplication_GetApplications_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchApplication> response = await client.GetApplicationAsync("my_application_id");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAPoolWithAcceleratedNetworking()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "mypool01",
                vmSize = "Standard_D1_v2",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "MicrosoftWindowsServer",
                        offer = "WindowsServer",
                        sku = "2016-datacenter-smalldisk",
                        version = "latest",
                    },
                    nodeAgentSKUId = "batch.node.windows amd64",
                },
                targetDedicatedNodes = 2,
                networkConfiguration = new
                {
                    enableAcceleratedNetworking = true,
                },
            });
            Response response = client.CreatePool(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAPoolWithAcceleratedNetworking_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "mypool01",
                vmSize = "Standard_D1_v2",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "MicrosoftWindowsServer",
                        offer = "WindowsServer",
                        sku = "2016-datacenter-smalldisk",
                        version = "latest",
                    },
                    nodeAgentSKUId = "batch.node.windows amd64",
                },
                targetDedicatedNodes = 2,
                networkConfiguration = new
                {
                    enableAcceleratedNetworking = true,
                },
            });
            Response response = await client.CreatePoolAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAPoolWithAcceleratedNetworking_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("mypool01", "Standard_D1_v2")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "MicrosoftWindowsServer",
                    Offer = "WindowsServer",
                    Sku = "2016-datacenter-smalldisk",
                    Version = "latest",
                }, "batch.node.windows amd64"),
                TargetDedicatedNodes = 2,
                NetworkConfiguration = new NetworkConfiguration
                {
                    EnableAcceleratedNetworking = true,
                },
            };
            Response response = client.CreatePool(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAPoolWithAcceleratedNetworking_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("mypool01", "Standard_D1_v2")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "MicrosoftWindowsServer",
                    Offer = "WindowsServer",
                    Sku = "2016-datacenter-smalldisk",
                    Version = "latest",
                }, "batch.node.windows amd64"),
                TargetDedicatedNodes = 2,
                NetworkConfiguration = new NetworkConfiguration
                {
                    EnableAcceleratedNetworking = true,
                },
            };
            Response response = await client.CreatePoolAsync(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAPoolWithMountDriveSpecified()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "pool2",
                vmSize = "standard_a1",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "Canonical",
                        offer = "UbuntuServer",
                        sku = "20_04-lts",
                    },
                    nodeAgentSKUId = "batch.node.ubuntu 20.04",
                },
                mountConfiguration = new object[]
            {
new
{
azureBlobFileSystemConfiguration = new
{
accountName = "accountName",
containerName = "blobContainerName",
accountKey = "accountKey",
relativeMountPath = "bfusepath",
},
},
new
{
azureFileShareConfiguration = new
{
accountName = "accountName",
azureFileUrl = "https://myaccount.file.core.windows.net/fileshare",
accountKey = "accountKey",
relativeMountPath = "filesharepath",
mountOptions = "mount options ver=1.0",
},
},
new
{
nfsMountConfiguration = new
{
source = "somesource nfs url",
relativeMountPath = "mountpath",
mountOptions = "mount options ver=1.0",
},
},
new
{
cifsMountConfiguration = new
{
username = "accountName",
password = "password",
source = "//myaccount.file.core.windows.net/file",
relativeMountPath = "mountpath",
mountOptions = "mount options ver=1.0",
},
}
            },
                resizeTimeout = "PT15M",
                targetDedicatedNodes = 5,
                targetLowPriorityNodes = 0,
                taskSlotsPerNode = 3,
                taskSchedulingPolicy = new
                {
                    nodeFillType = "spread",
                },
                enableAutoScale = false,
            });
            Response response = client.CreatePool(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAPoolWithMountDriveSpecified_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "pool2",
                vmSize = "standard_a1",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "Canonical",
                        offer = "UbuntuServer",
                        sku = "20_04-lts",
                    },
                    nodeAgentSKUId = "batch.node.ubuntu 20.04",
                },
                mountConfiguration = new object[]
            {
new
{
azureBlobFileSystemConfiguration = new
{
accountName = "accountName",
containerName = "blobContainerName",
accountKey = "accountKey",
relativeMountPath = "bfusepath",
},
},
new
{
azureFileShareConfiguration = new
{
accountName = "accountName",
azureFileUrl = "https://myaccount.file.core.windows.net/fileshare",
accountKey = "accountKey",
relativeMountPath = "filesharepath",
mountOptions = "mount options ver=1.0",
},
},
new
{
nfsMountConfiguration = new
{
source = "somesource nfs url",
relativeMountPath = "mountpath",
mountOptions = "mount options ver=1.0",
},
},
new
{
cifsMountConfiguration = new
{
username = "accountName",
password = "password",
source = "//myaccount.file.core.windows.net/file",
relativeMountPath = "mountpath",
mountOptions = "mount options ver=1.0",
},
}
            },
                resizeTimeout = "PT15M",
                targetDedicatedNodes = 5,
                targetLowPriorityNodes = 0,
                taskSlotsPerNode = 3,
                taskSchedulingPolicy = new
                {
                    nodeFillType = "spread",
                },
                enableAutoScale = false,
            });
            Response response = await client.CreatePoolAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAPoolWithMountDriveSpecified_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("pool2", "standard_a1")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "Canonical",
                    Offer = "UbuntuServer",
                    Sku = "20_04-lts",
                }, "batch.node.ubuntu 20.04"),
                ResizeTimeout = XmlConvert.ToTimeSpan("PT15M"),
                TargetDedicatedNodes = 5,
                TargetLowPriorityNodes = 0,
                EnableAutoScale = false,
                TaskSlotsPerNode = 3,
                TaskSchedulingPolicy = new BatchTaskSchedulingPolicy(BatchNodeFillType.Spread),
                MountConfiguration = {new MountConfiguration
{
AzureBlobFileSystemConfiguration = new AzureBlobFileSystemConfiguration("accountName", "blobContainerName", "bfusepath")
{
AccountKey = "accountKey",
},
}, new MountConfiguration
{
AzureFileShareConfiguration = new AzureFileShareConfiguration("accountName", "https://myaccount.file.core.windows.net/fileshare", "accountKey", "filesharepath")
{
MountOptions = "mount options ver=1.0",
},
}, new MountConfiguration
{
NfsMountConfiguration = new NfsMountConfiguration("somesource nfs url", "mountpath")
{
MountOptions = "mount options ver=1.0",
},
}, new MountConfiguration
{
CifsMountConfiguration = new CifsMountConfiguration("accountName", "//myaccount.file.core.windows.net/file", "mountpath", "password")
{
MountOptions = "mount options ver=1.0",
},
}},
            };
            Response response = client.CreatePool(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAPoolWithMountDriveSpecified_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("pool2", "standard_a1")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "Canonical",
                    Offer = "UbuntuServer",
                    Sku = "20_04-lts",
                }, "batch.node.ubuntu 20.04"),
                ResizeTimeout = XmlConvert.ToTimeSpan("PT15M"),
                TargetDedicatedNodes = 5,
                TargetLowPriorityNodes = 0,
                EnableAutoScale = false,
                TaskSlotsPerNode = 3,
                TaskSchedulingPolicy = new BatchTaskSchedulingPolicy(BatchNodeFillType.Spread),
                MountConfiguration = {new MountConfiguration
{
AzureBlobFileSystemConfiguration = new AzureBlobFileSystemConfiguration("accountName", "blobContainerName", "bfusepath")
{
AccountKey = "accountKey",
},
}, new MountConfiguration
{
AzureFileShareConfiguration = new AzureFileShareConfiguration("accountName", "https://myaccount.file.core.windows.net/fileshare", "accountKey", "filesharepath")
{
MountOptions = "mount options ver=1.0",
},
}, new MountConfiguration
{
NfsMountConfiguration = new NfsMountConfiguration("somesource nfs url", "mountpath")
{
MountOptions = "mount options ver=1.0",
},
}, new MountConfiguration
{
CifsMountConfiguration = new CifsMountConfiguration("accountName", "//myaccount.file.core.windows.net/file", "mountpath", "password")
{
MountOptions = "mount options ver=1.0",
},
}},
            };
            Response response = await client.CreatePoolAsync(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithOSDisk()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "mypool001",
                vmSize = "standard_d2s_v3",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "Canonical",
                        offer = "0001-com-ubuntu-server-focal",
                        sku = "20_04-lts",
                    },
                    osDisk = new
                    {
                        diskSizeGB = 100,
                        managedDisk = new
                        {
                            storageAccountType = "standardssd_lrs",
                        },
                        caching = "readwrite",
                        ephemeralOSDiskSettings = new
                        {
                            placement = "cachedisk",
                        },
                    },
                    nodeAgentSKUId = "batch.node.ubuntu 20.04",
                },
                resizeTimeout = "PT15M",
                targetDedicatedNodes = 1,
                targetLowPriorityNodes = 0,
                taskSlotsPerNode = 1,
                enableAutoScale = false,
            });
            Response response = client.CreatePool(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithOSDisk_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "mypool001",
                vmSize = "standard_d2s_v3",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "Canonical",
                        offer = "0001-com-ubuntu-server-focal",
                        sku = "20_04-lts",
                    },
                    osDisk = new
                    {
                        diskSizeGB = 100,
                        managedDisk = new
                        {
                            storageAccountType = "standardssd_lrs",
                        },
                        caching = "readwrite",
                        ephemeralOSDiskSettings = new
                        {
                            placement = "cachedisk",
                        },
                    },
                    nodeAgentSKUId = "batch.node.ubuntu 20.04",
                },
                resizeTimeout = "PT15M",
                targetDedicatedNodes = 1,
                targetLowPriorityNodes = 0,
                taskSlotsPerNode = 1,
                enableAutoScale = false,
            });
            Response response = await client.CreatePoolAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithOSDisk_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("mypool001", "standard_d2s_v3")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "Canonical",
                    Offer = "0001-com-ubuntu-server-focal",
                    Sku = "20_04-lts",
                }, "batch.node.ubuntu 20.04")
                {
                    OsDisk = new OSDisk
                    {
                        EphemeralOSDiskSettings = new DiffDiskSettings
                        {
                            Placement = DiffDiskPlacement.CacheDisk,
                        },
                        Caching = CachingType.ReadWrite,
                        DiskSizeGB = 100,
                        ManagedDisk = new ManagedDisk(StorageAccountType.StandardSSDLRS),
                    },
                },
                ResizeTimeout = XmlConvert.ToTimeSpan("PT15M"),
                TargetDedicatedNodes = 1,
                TargetLowPriorityNodes = 0,
                EnableAutoScale = false,
                TaskSlotsPerNode = 1,
            };
            Response response = client.CreatePool(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithOSDisk_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("mypool001", "standard_d2s_v3")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "Canonical",
                    Offer = "0001-com-ubuntu-server-focal",
                    Sku = "20_04-lts",
                }, "batch.node.ubuntu 20.04")
                {
                    OsDisk = new OSDisk
                    {
                        EphemeralOSDiskSettings = new DiffDiskSettings
                        {
                            Placement = DiffDiskPlacement.CacheDisk,
                        },
                        Caching = CachingType.ReadWrite,
                        DiskSizeGB = 100,
                        ManagedDisk = new ManagedDisk(StorageAccountType.StandardSSDLRS),
                    },
                },
                ResizeTimeout = XmlConvert.ToTimeSpan("PT15M"),
                TargetDedicatedNodes = 1,
                TargetLowPriorityNodes = 0,
                EnableAutoScale = false,
                TaskSlotsPerNode = 1,
            };
            Response response = await client.CreatePoolAsync(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesASimplePoolWithResourceTags()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "mypool001",
                vmSize = "STANDARD_DC2s_V2",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "Canonical",
                        offer = "UbuntuServer",
                        sku = "18_04-lts-gen2",
                        version = "latest",
                    },
                    nodeAgentSKUId = "batch.node.ubuntu 18.04",
                },
                targetDedicatedNodes = 1,
                resourceTags = new
                {
                    TagName1 = "TagValue1",
                    TagName2 = "TagValue2",
                },
            });
            Response response = client.CreatePool(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesASimplePoolWithResourceTags_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "mypool001",
                vmSize = "STANDARD_DC2s_V2",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "Canonical",
                        offer = "UbuntuServer",
                        sku = "18_04-lts-gen2",
                        version = "latest",
                    },
                    nodeAgentSKUId = "batch.node.ubuntu 18.04",
                },
                targetDedicatedNodes = 1,
                resourceTags = new
                {
                    TagName1 = "TagValue1",
                    TagName2 = "TagValue2",
                },
            });
            Response response = await client.CreatePoolAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesASimplePoolWithResourceTags_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("mypool001", "STANDARD_DC2s_V2")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "Canonical",
                    Offer = "UbuntuServer",
                    Sku = "18_04-lts-gen2",
                    Version = "latest",
                }, "batch.node.ubuntu 18.04"),
                ResourceTags =
{
["TagName1"] = "TagValue1",
["TagName2"] = "TagValue2"
},
                TargetDedicatedNodes = 1,
            };
            Response response = client.CreatePool(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesASimplePoolWithResourceTags_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("mypool001", "STANDARD_DC2s_V2")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "Canonical",
                    Offer = "UbuntuServer",
                    Sku = "18_04-lts-gen2",
                    Version = "latest",
                }, "batch.node.ubuntu 18.04"),
                ResourceTags =
{
["TagName1"] = "TagValue1",
["TagName2"] = "TagValue2"
},
                TargetDedicatedNodes = 1,
            };
            Response response = await client.CreatePoolAsync(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAPoolWithSecurityProfile()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "mypool001",
                vmSize = "STANDARD_DC2s_V2",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "Canonical",
                        offer = "UbuntuServer",
                        sku = "18_04-lts-gen2",
                        version = "latest",
                    },
                    nodeAgentSKUId = "batch.node.ubuntu 18.04",
                    securityProfile = new
                    {
                        securityType = "trustedLaunch",
                        encryptionAtHost = true,
                        uefiSettings = new
                        {
                            secureBootEnabled = false,
                        },
                    },
                },
                targetDedicatedNodes = 1,
            });
            Response response = client.CreatePool(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAPoolWithSecurityProfile_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "mypool001",
                vmSize = "STANDARD_DC2s_V2",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "Canonical",
                        offer = "UbuntuServer",
                        sku = "18_04-lts-gen2",
                        version = "latest",
                    },
                    nodeAgentSKUId = "batch.node.ubuntu 18.04",
                    securityProfile = new
                    {
                        securityType = "trustedLaunch",
                        encryptionAtHost = true,
                        uefiSettings = new
                        {
                            secureBootEnabled = false,
                        },
                    },
                },
                targetDedicatedNodes = 1,
            });
            Response response = await client.CreatePoolAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAPoolWithSecurityProfile_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("mypool001", "STANDARD_DC2s_V2")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "Canonical",
                    Offer = "UbuntuServer",
                    Sku = "18_04-lts-gen2",
                    Version = "latest",
                }, "batch.node.ubuntu 18.04")
                {
                    SecurityProfile = new SecurityProfile(true, SecurityTypes.TrustedLaunch, new UefiSettings
                    {
                        SecureBootEnabled = false,
                    }),
                },
                TargetDedicatedNodes = 1,
            };
            Response response = client.CreatePool(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAPoolWithSecurityProfile_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("mypool001", "STANDARD_DC2s_V2")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "Canonical",
                    Offer = "UbuntuServer",
                    Sku = "18_04-lts-gen2",
                    Version = "latest",
                }, "batch.node.ubuntu 18.04")
                {
                    SecurityProfile = new SecurityProfile(true, SecurityTypes.TrustedLaunch, new UefiSettings
                    {
                        SecureBootEnabled = false,
                    }),
                },
                TargetDedicatedNodes = 1,
            };
            Response response = await client.CreatePoolAsync(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPool()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "pool2",
                vmSize = "standard_a1",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "Canonical",
                        offer = "0001-com-ubuntu-server-focal",
                        sku = "20_04-lts",
                    },
                    nodeAgentSKUId = "batch.node.ubuntu 20.04",
                },
                resizeTimeout = "PT15M",
                targetDedicatedNodes = 5,
                targetLowPriorityNodes = 0,
                taskSlotsPerNode = 3,
                taskSchedulingPolicy = new
                {
                    nodeFillType = "spread",
                },
                enableAutoScale = false,
                enableInterNodeCommunication = true,
                metadata = new object[]
            {
new
{
name = "myproperty",
value = "myvalue",
}
            },
            });
            Response response = client.CreatePool(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPool_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "pool2",
                vmSize = "standard_a1",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "Canonical",
                        offer = "0001-com-ubuntu-server-focal",
                        sku = "20_04-lts",
                    },
                    nodeAgentSKUId = "batch.node.ubuntu 20.04",
                },
                resizeTimeout = "PT15M",
                targetDedicatedNodes = 5,
                targetLowPriorityNodes = 0,
                taskSlotsPerNode = 3,
                taskSchedulingPolicy = new
                {
                    nodeFillType = "spread",
                },
                enableAutoScale = false,
                enableInterNodeCommunication = true,
                metadata = new object[]
            {
new
{
name = "myproperty",
value = "myvalue",
}
            },
            });
            Response response = await client.CreatePoolAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPool_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("pool2", "standard_a1")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "Canonical",
                    Offer = "0001-com-ubuntu-server-focal",
                    Sku = "20_04-lts",
                }, "batch.node.ubuntu 20.04"),
                ResizeTimeout = XmlConvert.ToTimeSpan("PT15M"),
                TargetDedicatedNodes = 5,
                TargetLowPriorityNodes = 0,
                EnableAutoScale = false,
                EnableInterNodeCommunication = true,
                TaskSlotsPerNode = 3,
                TaskSchedulingPolicy = new BatchTaskSchedulingPolicy(BatchNodeFillType.Spread),
                Metadata = { new MetadataItem("myproperty", "myvalue") },
            };
            Response response = client.CreatePool(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPool_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("pool2", "standard_a1")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "Canonical",
                    Offer = "0001-com-ubuntu-server-focal",
                    Sku = "20_04-lts",
                }, "batch.node.ubuntu 20.04"),
                ResizeTimeout = XmlConvert.ToTimeSpan("PT15M"),
                TargetDedicatedNodes = 5,
                TargetLowPriorityNodes = 0,
                EnableAutoScale = false,
                EnableInterNodeCommunication = true,
                TaskSlotsPerNode = 3,
                TaskSchedulingPolicy = new BatchTaskSchedulingPolicy(BatchNodeFillType.Spread),
                Metadata = { new MetadataItem("myproperty", "myvalue") },
            };
            Response response = await client.CreatePoolAsync(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithContainers()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "pool2",
                vmSize = "standard_a1",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "Canonical",
                        offer = "0001-com-ubuntu-server-focal",
                        sku = "120_04-lts",
                    },
                    nodeAgentSKUId = "batch.node.ubuntu 20.04",
                    containerConfiguration = new
                    {
                        type = "dockerCompatible",
                        containerImageNames = new object[]
            {
"busybox"
            },
                    },
                },
                resizeTimeout = "PT15M",
                targetDedicatedNodes = 5,
                targetLowPriorityNodes = 0,
                taskSlotsPerNode = 3,
                taskSchedulingPolicy = new
                {
                    nodeFillType = "spread",
                },
                enableAutoScale = false,
            });
            Response response = client.CreatePool(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithContainers_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "pool2",
                vmSize = "standard_a1",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "Canonical",
                        offer = "0001-com-ubuntu-server-focal",
                        sku = "120_04-lts",
                    },
                    nodeAgentSKUId = "batch.node.ubuntu 20.04",
                    containerConfiguration = new
                    {
                        type = "dockerCompatible",
                        containerImageNames = new object[]
            {
"busybox"
            },
                    },
                },
                resizeTimeout = "PT15M",
                targetDedicatedNodes = 5,
                targetLowPriorityNodes = 0,
                taskSlotsPerNode = 3,
                taskSchedulingPolicy = new
                {
                    nodeFillType = "spread",
                },
                enableAutoScale = false,
            });
            Response response = await client.CreatePoolAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithContainers_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("pool2", "standard_a1")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "Canonical",
                    Offer = "0001-com-ubuntu-server-focal",
                    Sku = "120_04-lts",
                }, "batch.node.ubuntu 20.04")
                {
                    ContainerConfiguration = new ContainerConfiguration(ContainerType.DockerCompatible)
                    {
                        ContainerImageNames = { "busybox" },
                    },
                },
                ResizeTimeout = XmlConvert.ToTimeSpan("PT15M"),
                TargetDedicatedNodes = 5,
                TargetLowPriorityNodes = 0,
                EnableAutoScale = false,
                TaskSlotsPerNode = 3,
                TaskSchedulingPolicy = new BatchTaskSchedulingPolicy(BatchNodeFillType.Spread),
            };
            Response response = client.CreatePool(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithContainers_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("pool2", "standard_a1")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "Canonical",
                    Offer = "0001-com-ubuntu-server-focal",
                    Sku = "120_04-lts",
                }, "batch.node.ubuntu 20.04")
                {
                    ContainerConfiguration = new ContainerConfiguration(ContainerType.DockerCompatible)
                    {
                        ContainerImageNames = { "busybox" },
                    },
                },
                ResizeTimeout = XmlConvert.ToTimeSpan("PT15M"),
                TargetDedicatedNodes = 5,
                TargetLowPriorityNodes = 0,
                EnableAutoScale = false,
                TaskSlotsPerNode = 3,
                TaskSchedulingPolicy = new BatchTaskSchedulingPolicy(BatchNodeFillType.Spread),
            };
            Response response = await client.CreatePoolAsync(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithExtensions()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "pool2",
                vmSize = "standard_a1",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "Canonical",
                        offer = "0001-com-ubuntu-server-focal",
                        sku = "20_04-lts",
                    },
                    nodeAgentSKUId = "batch.node.ubuntu 20.04",
                    extensions = new object[]
            {
new
{
name = "batchextension1",
type = "KeyVaultForLinux",
publisher = "Microsoft.Azure.KeyVault",
typeHandlerVersion = "2.0",
autoUpgradeMinorVersion = true,
enableAutomaticUpgrade = true,
settings = new
{
secretsManagementSettingsKey = "secretsManagementSettingsValue",
authenticationSettingsKey = "authenticationSettingsValue",
},
}
            },
                },
                resizeTimeout = "PT15M",
                targetDedicatedNodes = 5,
                targetLowPriorityNodes = 0,
                taskSlotsPerNode = 3,
                taskSchedulingPolicy = new
                {
                    nodeFillType = "spread",
                },
                enableAutoScale = false,
                enableInterNodeCommunication = true,
                metadata = new object[]
            {
new
{
name = "myproperty",
value = "myvalue",
}
            },
                targetNodeCommunicationMode = "simplified",
            });
            Response response = client.CreatePool(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithExtensions_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "pool2",
                vmSize = "standard_a1",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "Canonical",
                        offer = "0001-com-ubuntu-server-focal",
                        sku = "20_04-lts",
                    },
                    nodeAgentSKUId = "batch.node.ubuntu 20.04",
                    extensions = new object[]
            {
new
{
name = "batchextension1",
type = "KeyVaultForLinux",
publisher = "Microsoft.Azure.KeyVault",
typeHandlerVersion = "2.0",
autoUpgradeMinorVersion = true,
enableAutomaticUpgrade = true,
settings = new
{
secretsManagementSettingsKey = "secretsManagementSettingsValue",
authenticationSettingsKey = "authenticationSettingsValue",
},
}
            },
                },
                resizeTimeout = "PT15M",
                targetDedicatedNodes = 5,
                targetLowPriorityNodes = 0,
                taskSlotsPerNode = 3,
                taskSchedulingPolicy = new
                {
                    nodeFillType = "spread",
                },
                enableAutoScale = false,
                enableInterNodeCommunication = true,
                metadata = new object[]
            {
new
{
name = "myproperty",
value = "myvalue",
}
            },
                targetNodeCommunicationMode = "simplified",
            });
            Response response = await client.CreatePoolAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithExtensions_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("pool2", "standard_a1")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "Canonical",
                    Offer = "0001-com-ubuntu-server-focal",
                    Sku = "20_04-lts",
                }, "batch.node.ubuntu 20.04")
                {
                    Extensions = {new VMExtension("batchextension1", "Microsoft.Azure.KeyVault", "KeyVaultForLinux")
{
TypeHandlerVersion = "2.0",
AutoUpgradeMinorVersion = true,
EnableAutomaticUpgrade = true,
Settings =
{
["secretsManagementSettingsKey"] = "secretsManagementSettingsValue",
["authenticationSettingsKey"] = "authenticationSettingsValue"
},
}},
                },
                ResizeTimeout = XmlConvert.ToTimeSpan("PT15M"),
                TargetDedicatedNodes = 5,
                TargetLowPriorityNodes = 0,
                EnableAutoScale = false,
                EnableInterNodeCommunication = true,
                TaskSlotsPerNode = 3,
                TaskSchedulingPolicy = new BatchTaskSchedulingPolicy(BatchNodeFillType.Spread),
                Metadata = { new MetadataItem("myproperty", "myvalue") },
                TargetNodeCommunicationMode = BatchNodeCommunicationMode.Simplified,
            };
            Response response = client.CreatePool(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithExtensions_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("pool2", "standard_a1")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "Canonical",
                    Offer = "0001-com-ubuntu-server-focal",
                    Sku = "20_04-lts",
                }, "batch.node.ubuntu 20.04")
                {
                    Extensions = {new VMExtension("batchextension1", "Microsoft.Azure.KeyVault", "KeyVaultForLinux")
{
TypeHandlerVersion = "2.0",
AutoUpgradeMinorVersion = true,
EnableAutomaticUpgrade = true,
Settings =
{
["secretsManagementSettingsKey"] = "secretsManagementSettingsValue",
["authenticationSettingsKey"] = "authenticationSettingsValue"
},
}},
                },
                ResizeTimeout = XmlConvert.ToTimeSpan("PT15M"),
                TargetDedicatedNodes = 5,
                TargetLowPriorityNodes = 0,
                EnableAutoScale = false,
                EnableInterNodeCommunication = true,
                TaskSlotsPerNode = 3,
                TaskSchedulingPolicy = new BatchTaskSchedulingPolicy(BatchNodeFillType.Spread),
                Metadata = { new MetadataItem("myproperty", "myvalue") },
                TargetNodeCommunicationMode = BatchNodeCommunicationMode.Simplified,
            };
            Response response = await client.CreatePoolAsync(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithServiceArtifactReference()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "mypool002",
                vmSize = "Standard_A1_v2",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "MicrosoftWindowsServer",
                        offer = "WindowsServer",
                        sku = "2016-datacenter-smalldisk",
                        version = "latest",
                    },
                    windowsConfiguration = new
                    {
                        enableAutomaticUpdates = false,
                    },
                    serviceArtifactReference = new
                    {
                        id = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Compute/galleries/myGallery/serviceArtifacts/myServiceArtifact/vmArtifactsProfiles/vmArtifactsProfile",
                    },
                    nodeAgentSKUId = "batch.node.windows amd64",
                },
                targetDedicatedNodes = 2,
            });
            Response response = client.CreatePool(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithServiceArtifactReference_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "mypool002",
                vmSize = "Standard_A1_v2",
                virtualMachineConfiguration = new
                {
                    imageReference = new
                    {
                        publisher = "MicrosoftWindowsServer",
                        offer = "WindowsServer",
                        sku = "2016-datacenter-smalldisk",
                        version = "latest",
                    },
                    windowsConfiguration = new
                    {
                        enableAutomaticUpdates = false,
                    },
                    serviceArtifactReference = new
                    {
                        id = "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Compute/galleries/myGallery/serviceArtifacts/myServiceArtifact/vmArtifactsProfiles/vmArtifactsProfile",
                    },
                    nodeAgentSKUId = "batch.node.windows amd64",
                },
                targetDedicatedNodes = 2,
            });
            Response response = await client.CreatePoolAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithServiceArtifactReference_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("mypool002", "Standard_A1_v2")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "MicrosoftWindowsServer",
                    Offer = "WindowsServer",
                    Sku = "2016-datacenter-smalldisk",
                    Version = "latest",
                }, "batch.node.windows amd64")
                {
                    WindowsConfiguration = new WindowsConfiguration
                    {
                        EnableAutomaticUpdates = false,
                    },
                    ServiceArtifactReference = new ServiceArtifactReference("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Compute/galleries/myGallery/serviceArtifacts/myServiceArtifact/vmArtifactsProfiles/vmArtifactsProfile"),
                },
                TargetDedicatedNodes = 2,
            };
            Response response = client.CreatePool(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreatePool_CreatesAVirtualMachineConfigurationPoolWithServiceArtifactReference_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolCreateContent pool = new BatchPoolCreateContent("mypool002", "Standard_A1_v2")
            {
                VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                {
                    Publisher = "MicrosoftWindowsServer",
                    Offer = "WindowsServer",
                    Sku = "2016-datacenter-smalldisk",
                    Version = "latest",
                }, "batch.node.windows amd64")
                {
                    WindowsConfiguration = new WindowsConfiguration
                    {
                        EnableAutomaticUpdates = false,
                    },
                    ServiceArtifactReference = new ServiceArtifactReference("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Compute/galleries/myGallery/serviceArtifacts/myServiceArtifact/vmArtifactsProfiles/vmArtifactsProfile"),
                },
                TargetDedicatedNodes = 2,
            };
            Response response = await client.CreatePoolAsync(pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_DeletePool_PoolDelete()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.DeletePool("poolId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_DeletePool_PoolDelete_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.DeletePoolAsync("poolId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPool_GetAPoolWithAcceleratedNetworking()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetPool("pool", null, DateTimeOffset.Parse("Fri, 28 Apr 2023 02:43:01 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPool_GetAPoolWithAcceleratedNetworking_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetPoolAsync("pool", null, DateTimeOffset.Parse("Fri, 28 Apr 2023 02:43:01 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPool_GetAPoolWithAcceleratedNetworking_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchPool> response = client.GetPool("pool");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPool_GetAPoolWithAcceleratedNetworking_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchPool> response = await client.GetPoolAsync("pool");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPool_PoolGet()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetPool("pool", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPool_PoolGet_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetPoolAsync("pool", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPool_PoolGet_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchPool> response = client.GetPool("pool");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPool_PoolGet_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchPool> response = await client.GetPoolAsync("pool");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPool_GetAVirtualMachineConfigurationPoolWithSecurityProfile()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetPool("mypool001", null, DateTimeOffset.Parse("Wed, 14 Jun 2023 06:39:01 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPool_GetAVirtualMachineConfigurationPoolWithSecurityProfile_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetPoolAsync("mypool001", null, DateTimeOffset.Parse("Wed, 14 Jun 2023 06:39:01 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPool_GetAVirtualMachineConfigurationPoolWithSecurityProfile_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchPool> response = client.GetPool("mypool001");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPool_GetAVirtualMachineConfigurationPoolWithSecurityProfile_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchPool> response = await client.GetPoolAsync("mypool001");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPool_GetAVirtualMachineConfigurationPoolWithExtensions()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetPool("pool", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPool_GetAVirtualMachineConfigurationPoolWithExtensions_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetPoolAsync("pool", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPool_GetAVirtualMachineConfigurationPoolWithExtensions_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchPool> response = client.GetPool("pool");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPool_GetAVirtualMachineConfigurationPoolWithExtensions_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchPool> response = await client.GetPoolAsync("pool");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPool_AddAVirtualMachineConfigurationPoolWithOSDisk()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetPool("mypool001", null, DateTimeOffset.Parse("Wed, 23 Aug 2023 08:42:01 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPool_AddAVirtualMachineConfigurationPoolWithOSDisk_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetPoolAsync("mypool001", null, DateTimeOffset.Parse("Wed, 23 Aug 2023 08:42:01 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPool_AddAVirtualMachineConfigurationPoolWithOSDisk_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchPool> response = client.GetPool("mypool001");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPool_AddAVirtualMachineConfigurationPoolWithOSDisk_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchPool> response = await client.GetPoolAsync("mypool001");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPool_GetAVirtualMachineConfigurationPoolWithServiceArtifactReference()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetPool("pool", null, DateTimeOffset.Parse("Thu, 11 May 2023 08:08:01 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPool_GetAVirtualMachineConfigurationPoolWithServiceArtifactReference_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetPoolAsync("pool", null, DateTimeOffset.Parse("Thu, 11 May 2023 08:08:01 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPool_GetAVirtualMachineConfigurationPoolWithServiceArtifactReference_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchPool> response = client.GetPool("pool");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPool_GetAVirtualMachineConfigurationPoolWithServiceArtifactReference_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchPool> response = await client.GetPoolAsync("pool");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_UpdatePool_PatchThePool()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                startTask = new
                {
                    commandLine = "/bin/bash -c 'echo start task'",
                },
            });
            Response response = client.UpdatePool("poolId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_UpdatePool_PatchThePool_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                startTask = new
                {
                    commandLine = "/bin/bash -c 'echo start task'",
                },
            });
            Response response = await client.UpdatePoolAsync("poolId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_DisablePoolAutoScale_DisablePoolAutoscale()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.DisablePoolAutoScale("poolId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_DisablePoolAutoScale_DisablePoolAutoscale_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.DisablePoolAutoScaleAsync("poolId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_EnablePoolAutoScale_PoolEnableAutoscale()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                autoScaleFormula = "$TargetDedicated=0",
                autoScaleEvaluationInterval = "PT8M",
            });
            Response response = client.EnablePoolAutoScale("poolId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_EnablePoolAutoScale_PoolEnableAutoscale_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                autoScaleFormula = "$TargetDedicated=0",
                autoScaleEvaluationInterval = "PT8M",
            });
            Response response = await client.EnablePoolAutoScaleAsync("poolId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_EnablePoolAutoScale_PoolEnableAutoscale_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolEnableAutoScaleContent content = new BatchPoolEnableAutoScaleContent
            {
                AutoScaleFormula = "$TargetDedicated=0",
                AutoScaleEvaluationInterval = XmlConvert.ToTimeSpan("PT8M"),
            };
            Response response = client.EnablePoolAutoScale("poolId", content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_EnablePoolAutoScale_PoolEnableAutoscale_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolEnableAutoScaleContent content = new BatchPoolEnableAutoScaleContent
            {
                AutoScaleFormula = "$TargetDedicated=0",
                AutoScaleEvaluationInterval = XmlConvert.ToTimeSpan("PT8M"),
            };
            Response response = await client.EnablePoolAutoScaleAsync("poolId", content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_EvaluatePoolAutoScale_PoolEvaluateAutoscale()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                autoScaleFormula = "$TargetDedicated=1",
            });
            Response response = client.EvaluatePoolAutoScale("poolId", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("timestamp").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_EvaluatePoolAutoScale_PoolEvaluateAutoscale_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                autoScaleFormula = "$TargetDedicated=1",
            });
            Response response = await client.EvaluatePoolAutoScaleAsync("poolId", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("timestamp").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_EvaluatePoolAutoScale_PoolEvaluateAutoscale_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolEvaluateAutoScaleContent content = new BatchPoolEvaluateAutoScaleContent("$TargetDedicated=1");
            Response<AutoScaleRun> response = client.EvaluatePoolAutoScale("poolId", content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_EvaluatePoolAutoScale_PoolEvaluateAutoscale_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolEvaluateAutoScaleContent content = new BatchPoolEvaluateAutoScaleContent("$TargetDedicated=1");
            Response<AutoScaleRun> response = await client.EvaluatePoolAutoScaleAsync("poolId", content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_ResizePool_PoolResize()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                targetDedicatedNodes = 1,
                targetLowPriorityNodes = 0,
            });
            Response response = client.ResizePool("resizePool", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_ResizePool_PoolResize_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                targetDedicatedNodes = 1,
                targetLowPriorityNodes = 0,
            });
            Response response = await client.ResizePoolAsync("resizePool", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_ResizePool_PoolResize_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolResizeContent content = new BatchPoolResizeContent
            {
                TargetDedicatedNodes = 1,
                TargetLowPriorityNodes = 0,
            };
            Response response = client.ResizePool("resizePool", content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_ResizePool_PoolResize_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolResizeContent content = new BatchPoolResizeContent
            {
                TargetDedicatedNodes = 1,
                TargetLowPriorityNodes = 0,
            };
            Response response = await client.ResizePoolAsync("resizePool", content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_StopPoolResize_PoolStopResize()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.StopPoolResize("poolId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_StopPoolResize_PoolStopResize_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.StopPoolResizeAsync("poolId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_ReplacePoolProperties_PoolUpdate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                startTask = new
                {
                    commandLine = "/bin/bash -c 'echo start task'",
                },
                applicationPackageReferences = Array.Empty<object>(),
                metadata = Array.Empty<object>(),
            });
            Response response = client.ReplacePoolProperties("poolId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_ReplacePoolProperties_PoolUpdate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                startTask = new
                {
                    commandLine = "/bin/bash -c 'echo start task'",
                },
                applicationPackageReferences = Array.Empty<object>(),
                metadata = Array.Empty<object>(),
            });
            Response response = await client.ReplacePoolPropertiesAsync("poolId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_ReplacePoolProperties_PoolUpdate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolReplaceContent pool = new BatchPoolReplaceContent(Array.Empty<BatchApplicationPackageReference>(), Array.Empty<MetadataItem>())
            {
                StartTask = new BatchStartTask("/bin/bash -c 'echo start task'"),
            };
            Response response = client.ReplacePoolProperties("poolId", pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_ReplacePoolProperties_PoolUpdate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchPoolReplaceContent pool = new BatchPoolReplaceContent(Array.Empty<BatchApplicationPackageReference>(), Array.Empty<MetadataItem>())
            {
                StartTask = new BatchStartTask("/bin/bash -c 'echo start task'"),
            };
            Response response = await client.ReplacePoolPropertiesAsync("poolId", pool);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_RemoveNodes_PoolRemoveNodes()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                nodeList = new object[]
            {
"tvm-1695681911_1-20161122t224741z",
"tvm-1695681911_2-20161122t224741z"
            },
            });
            Response response = client.RemoveNodes("poolId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_RemoveNodes_PoolRemoveNodes_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                nodeList = new object[]
            {
"tvm-1695681911_1-20161122t224741z",
"tvm-1695681911_2-20161122t224741z"
            },
            });
            Response response = await client.RemoveNodesAsync("poolId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_RemoveNodes_PoolRemoveNodes_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchNodeRemoveContent content = new BatchNodeRemoveContent(new string[] { "tvm-1695681911_1-20161122t224741z", "tvm-1695681911_2-20161122t224741z" });
            Response response = client.RemoveNodes("poolId", content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_RemoveNodes_PoolRemoveNodes_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchNodeRemoveContent content = new BatchNodeRemoveContent(new string[] { "tvm-1695681911_1-20161122t224741z", "tvm-1695681911_2-20161122t224741z" });
            Response response = await client.RemoveNodesAsync("poolId", content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_DeleteJob_DeleteJob()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.DeleteJob("jobId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_DeleteJob_DeleteJob_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.DeleteJobAsync("jobId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetJob_JobGet()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetJob("jobId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("poolInfo").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetJob_JobGet_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetJobAsync("jobId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("poolInfo").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetJob_JobGet_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchJob> response = client.GetJob("jobId");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetJob_JobGet_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchJob> response = await client.GetJobAsync("jobId");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_UpdateJob_JobPatch()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                priority = 100,
                constraints = new
                {
                    maxWallClockTime = "PT1H",
                    maxTaskRetryCount = -1,
                },
                poolInfo = new
                {
                    poolId = "poolId",
                },
            });
            Response response = client.UpdateJob("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_UpdateJob_JobPatch_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                priority = 100,
                constraints = new
                {
                    maxWallClockTime = "PT1H",
                    maxTaskRetryCount = -1,
                },
                poolInfo = new
                {
                    poolId = "poolId",
                },
            });
            Response response = await client.UpdateJobAsync("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_ReplaceJob_JobUpdate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                priority = 100,
                constraints = new
                {
                    maxWallClockTime = "PT1H",
                    maxTaskRetryCount = -1,
                },
                poolInfo = new
                {
                    poolId = "poolId",
                },
            });
            Response response = client.ReplaceJob("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_ReplaceJob_JobUpdate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                priority = 100,
                constraints = new
                {
                    maxWallClockTime = "PT1H",
                    maxTaskRetryCount = -1,
                },
                poolInfo = new
                {
                    poolId = "poolId",
                },
            });
            Response response = await client.ReplaceJobAsync("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_ReplaceJob_JobUpdate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchJob job = new BatchJob(new BatchPoolInfo
            {
                PoolId = "poolId",
            })
            {
                Priority = 100,
                Constraints = new BatchJobConstraints
                {
                    MaxWallClockTime = XmlConvert.ToTimeSpan("PT1H"),
                    MaxTaskRetryCount = -1,
                },
            };
            Response response = client.ReplaceJob("jobId", job);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_ReplaceJob_JobUpdate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchJob job = new BatchJob(new BatchPoolInfo
            {
                PoolId = "poolId",
            })
            {
                Priority = 100,
                Constraints = new BatchJobConstraints
                {
                    MaxWallClockTime = XmlConvert.ToTimeSpan("PT1H"),
                    MaxTaskRetryCount = -1,
                },
            };
            Response response = await client.ReplaceJobAsync("jobId", job);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_DisableJob_JobDisable()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                disableTasks = "terminate",
            });
            Response response = client.DisableJob("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_DisableJob_JobDisable_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                disableTasks = "terminate",
            });
            Response response = await client.DisableJobAsync("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_DisableJob_JobDisable_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchJobDisableContent content = new BatchJobDisableContent(DisableBatchJobOption.Terminate);
            Response response = client.DisableJob("jobId", content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_DisableJob_JobDisable_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchJobDisableContent content = new BatchJobDisableContent(DisableBatchJobOption.Terminate);
            Response response = await client.DisableJobAsync("jobId", content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_EnableJob_JobEnable()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.EnableJob("jobId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_EnableJob_JobEnable_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.EnableJobAsync("jobId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_TerminateJob_JobTerminate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = null;
            Response response = client.TerminateJob("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_TerminateJob_JobTerminate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = null;
            Response response = await client.TerminateJobAsync("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_TerminateJob_JobTerminate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.TerminateJob("jobId");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_TerminateJob_JobTerminate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.TerminateJobAsync("jobId");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateJob_CreatesABasicJob()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "jobId",
                priority = 0,
                poolInfo = new
                {
                    poolId = "poolId",
                },
            });
            Response response = client.CreateJob(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateJob_CreatesABasicJob_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "jobId",
                priority = 0,
                poolInfo = new
                {
                    poolId = "poolId",
                },
            });
            Response response = await client.CreateJobAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateJob_CreatesABasicJob_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchJobCreateContent job = new BatchJobCreateContent("jobId", new BatchPoolInfo
            {
                PoolId = "poolId",
            })
            {
                Priority = 0,
            };
            Response response = client.CreateJob(job);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateJob_CreatesABasicJob_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchJobCreateContent job = new BatchJobCreateContent("jobId", new BatchPoolInfo
            {
                PoolId = "poolId",
            })
            {
                Priority = 0,
            };
            Response response = await client.CreateJobAsync(job);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateJob_CreatesAComplexJob()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "jobId",
                priority = 100,
                constraints = new
                {
                    maxWallClockTime = "PT1H",
                    maxTaskRetryCount = -1,
                },
                jobManagerTask = new
                {
                    id = "taskId",
                    commandLine = "myprogram.exe",
                    resourceFiles = new object[]
            {
new
{
httpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram.exe?sas",
filePath = "myprogram.exe",
},
new
{
storageContainerUrl = "http://mystorage1.blob.core.windows.net/data?sas",
filePath = "datafolder",
}
            },
                    environmentSettings = new object[]
            {
new
{
name = "myvariable",
value = "myvalue",
}
            },
                    constraints = new
                    {
                        maxWallClockTime = "PT1H",
                        maxTaskRetryCount = 0,
                        retentionTime = "PT1H",
                    },
                    requiredSlots = 2,
                    killJobOnCompletion = false,
                    userIdentity = new
                    {
                        autoUser = new
                        {
                            scope = "task",
                            elevationLevel = "admin",
                        },
                    },
                    runExclusive = true,
                },
                poolInfo = new
                {
                    autoPoolSpecification = new
                    {
                        autoPoolIdPrefix = "mypool",
                        poolLifetimeOption = "job",
                        pool = new
                        {
                            vmSize = "Standard_D1_v2",
                            virtualMachineConfiguration = new
                            {
                                imageReference = new
                                {
                                    publisher = "MicrosoftWindowsServer",
                                    offer = "WindowsServer",
                                    sku = "2016-datacenter-smalldisk",
                                    version = "latest",
                                },
                                nodeAgentSKUId = "batch.node.windows amd64",
                            },
                            resizeTimeout = "PT15M",
                            targetDedicatedNodes = 3,
                            targetLowPriorityNodes = 0,
                            taskSlotsPerNode = 2,
                            taskSchedulingPolicy = new
                            {
                                nodeFillType = "spread",
                            },
                            enableAutoScale = false,
                            enableInterNodeCommunication = true,
                            startTask = new
                            {
                                commandLine = "myprogram2.exe",
                                resourceFiles = new object[]
            {
new
{
httpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram2.exe?sas",
filePath = "myprogram2.exe",
}
            },
                                environmentSettings = new object[]
            {
new
{
name = "myvariable",
value = "myvalue",
}
            },
                                userIdentity = new
                                {
                                    autoUser = new
                                    {
                                        scope = "task",
                                        elevationLevel = "admin",
                                    },
                                },
                                maxTaskRetryCount = 2,
                                waitForSuccess = true,
                            },
                            metadata = new object[]
            {
new
{
name = "myproperty",
value = "myvalue",
}
            },
                            targetNodeCommunicationMode = "default",
                        },
                    },
                },
                metadata = new object[]
            {
new
{
name = "myproperty",
value = "myvalue",
}
            },
            });
            Response response = client.CreateJob(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateJob_CreatesAComplexJob_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "jobId",
                priority = 100,
                constraints = new
                {
                    maxWallClockTime = "PT1H",
                    maxTaskRetryCount = -1,
                },
                jobManagerTask = new
                {
                    id = "taskId",
                    commandLine = "myprogram.exe",
                    resourceFiles = new object[]
            {
new
{
httpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram.exe?sas",
filePath = "myprogram.exe",
},
new
{
storageContainerUrl = "http://mystorage1.blob.core.windows.net/data?sas",
filePath = "datafolder",
}
            },
                    environmentSettings = new object[]
            {
new
{
name = "myvariable",
value = "myvalue",
}
            },
                    constraints = new
                    {
                        maxWallClockTime = "PT1H",
                        maxTaskRetryCount = 0,
                        retentionTime = "PT1H",
                    },
                    requiredSlots = 2,
                    killJobOnCompletion = false,
                    userIdentity = new
                    {
                        autoUser = new
                        {
                            scope = "task",
                            elevationLevel = "admin",
                        },
                    },
                    runExclusive = true,
                },
                poolInfo = new
                {
                    autoPoolSpecification = new
                    {
                        autoPoolIdPrefix = "mypool",
                        poolLifetimeOption = "job",
                        pool = new
                        {
                            vmSize = "Standard_D1_v2",
                            virtualMachineConfiguration = new
                            {
                                imageReference = new
                                {
                                    publisher = "MicrosoftWindowsServer",
                                    offer = "WindowsServer",
                                    sku = "2016-datacenter-smalldisk",
                                    version = "latest",
                                },
                                nodeAgentSKUId = "batch.node.windows amd64",
                            },
                            resizeTimeout = "PT15M",
                            targetDedicatedNodes = 3,
                            targetLowPriorityNodes = 0,
                            taskSlotsPerNode = 2,
                            taskSchedulingPolicy = new
                            {
                                nodeFillType = "spread",
                            },
                            enableAutoScale = false,
                            enableInterNodeCommunication = true,
                            startTask = new
                            {
                                commandLine = "myprogram2.exe",
                                resourceFiles = new object[]
            {
new
{
httpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram2.exe?sas",
filePath = "myprogram2.exe",
}
            },
                                environmentSettings = new object[]
            {
new
{
name = "myvariable",
value = "myvalue",
}
            },
                                userIdentity = new
                                {
                                    autoUser = new
                                    {
                                        scope = "task",
                                        elevationLevel = "admin",
                                    },
                                },
                                maxTaskRetryCount = 2,
                                waitForSuccess = true,
                            },
                            metadata = new object[]
            {
new
{
name = "myproperty",
value = "myvalue",
}
            },
                            targetNodeCommunicationMode = "default",
                        },
                    },
                },
                metadata = new object[]
            {
new
{
name = "myproperty",
value = "myvalue",
}
            },
            });
            Response response = await client.CreateJobAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateJob_CreatesAComplexJob_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchJobCreateContent job = new BatchJobCreateContent("jobId", new BatchPoolInfo
            {
                AutoPoolSpecification = new BatchAutoPoolSpecification(BatchPoolLifetimeOption.Job)
                {
                    AutoPoolIdPrefix = "mypool",
                    Pool = new BatchPoolSpecification("Standard_D1_v2")
                    {
                        VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                        {
                            Publisher = "MicrosoftWindowsServer",
                            Offer = "WindowsServer",
                            Sku = "2016-datacenter-smalldisk",
                            Version = "latest",
                        }, "batch.node.windows amd64"),
                        TaskSlotsPerNode = 2,
                        TaskSchedulingPolicy = new BatchTaskSchedulingPolicy(BatchNodeFillType.Spread),
                        ResizeTimeout = XmlConvert.ToTimeSpan("PT15M"),
                        TargetDedicatedNodes = 3,
                        TargetLowPriorityNodes = 0,
                        EnableAutoScale = false,
                        EnableInterNodeCommunication = true,
                        StartTask = new BatchStartTask("myprogram2.exe")
                        {
                            ResourceFiles = {new ResourceFile
{
HttpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram2.exe?sas",
FilePath = "myprogram2.exe",
}},
                            EnvironmentSettings = {new EnvironmentSetting("myvariable")
{
Value = "myvalue",
}},
                            UserIdentity = new UserIdentity
                            {
                                AutoUser = new AutoUserSpecification
                                {
                                    Scope = AutoUserScope.Task,
                                    ElevationLevel = ElevationLevel.Admin,
                                },
                            },
                            MaxTaskRetryCount = 2,
                            WaitForSuccess = true,
                        },
                        Metadata = { new MetadataItem("myproperty", "myvalue") },
                        TargetNodeCommunicationMode = BatchNodeCommunicationMode.Default,
                    },
                },
            })
            {
                Priority = 100,
                Constraints = new BatchJobConstraints
                {
                    MaxWallClockTime = XmlConvert.ToTimeSpan("PT1H"),
                    MaxTaskRetryCount = -1,
                },
                JobManagerTask = new BatchJobManagerTask("taskId", "myprogram.exe")
                {
                    ResourceFiles = {new ResourceFile
{
HttpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram.exe?sas",
FilePath = "myprogram.exe",
}, new ResourceFile
{
StorageContainerUrl = "http://mystorage1.blob.core.windows.net/data?sas",
FilePath = "datafolder",
}},
                    EnvironmentSettings = {new EnvironmentSetting("myvariable")
{
Value = "myvalue",
}},
                    Constraints = new BatchTaskConstraints
                    {
                        MaxWallClockTime = XmlConvert.ToTimeSpan("PT1H"),
                        RetentionTime = XmlConvert.ToTimeSpan("PT1H"),
                        MaxTaskRetryCount = 0,
                    },
                    RequiredSlots = 2,
                    KillJobOnCompletion = false,
                    UserIdentity = new UserIdentity
                    {
                        AutoUser = new AutoUserSpecification
                        {
                            Scope = AutoUserScope.Task,
                            ElevationLevel = ElevationLevel.Admin,
                        },
                    },
                    RunExclusive = true,
                },
                Metadata = { new MetadataItem("myproperty", "myvalue") },
            };
            Response response = client.CreateJob(job);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateJob_CreatesAComplexJob_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchJobCreateContent job = new BatchJobCreateContent("jobId", new BatchPoolInfo
            {
                AutoPoolSpecification = new BatchAutoPoolSpecification(BatchPoolLifetimeOption.Job)
                {
                    AutoPoolIdPrefix = "mypool",
                    Pool = new BatchPoolSpecification("Standard_D1_v2")
                    {
                        VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                        {
                            Publisher = "MicrosoftWindowsServer",
                            Offer = "WindowsServer",
                            Sku = "2016-datacenter-smalldisk",
                            Version = "latest",
                        }, "batch.node.windows amd64"),
                        TaskSlotsPerNode = 2,
                        TaskSchedulingPolicy = new BatchTaskSchedulingPolicy(BatchNodeFillType.Spread),
                        ResizeTimeout = XmlConvert.ToTimeSpan("PT15M"),
                        TargetDedicatedNodes = 3,
                        TargetLowPriorityNodes = 0,
                        EnableAutoScale = false,
                        EnableInterNodeCommunication = true,
                        StartTask = new BatchStartTask("myprogram2.exe")
                        {
                            ResourceFiles = {new ResourceFile
{
HttpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram2.exe?sas",
FilePath = "myprogram2.exe",
}},
                            EnvironmentSettings = {new EnvironmentSetting("myvariable")
{
Value = "myvalue",
}},
                            UserIdentity = new UserIdentity
                            {
                                AutoUser = new AutoUserSpecification
                                {
                                    Scope = AutoUserScope.Task,
                                    ElevationLevel = ElevationLevel.Admin,
                                },
                            },
                            MaxTaskRetryCount = 2,
                            WaitForSuccess = true,
                        },
                        Metadata = { new MetadataItem("myproperty", "myvalue") },
                        TargetNodeCommunicationMode = BatchNodeCommunicationMode.Default,
                    },
                },
            })
            {
                Priority = 100,
                Constraints = new BatchJobConstraints
                {
                    MaxWallClockTime = XmlConvert.ToTimeSpan("PT1H"),
                    MaxTaskRetryCount = -1,
                },
                JobManagerTask = new BatchJobManagerTask("taskId", "myprogram.exe")
                {
                    ResourceFiles = {new ResourceFile
{
HttpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram.exe?sas",
FilePath = "myprogram.exe",
}, new ResourceFile
{
StorageContainerUrl = "http://mystorage1.blob.core.windows.net/data?sas",
FilePath = "datafolder",
}},
                    EnvironmentSettings = {new EnvironmentSetting("myvariable")
{
Value = "myvalue",
}},
                    Constraints = new BatchTaskConstraints
                    {
                        MaxWallClockTime = XmlConvert.ToTimeSpan("PT1H"),
                        RetentionTime = XmlConvert.ToTimeSpan("PT1H"),
                        MaxTaskRetryCount = 0,
                    },
                    RequiredSlots = 2,
                    KillJobOnCompletion = false,
                    UserIdentity = new UserIdentity
                    {
                        AutoUser = new AutoUserSpecification
                        {
                            Scope = AutoUserScope.Task,
                            ElevationLevel = ElevationLevel.Admin,
                        },
                    },
                    RunExclusive = true,
                },
                Metadata = { new MetadataItem("myproperty", "myvalue") },
            };
            Response response = await client.CreateJobAsync(job);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetJobTaskCounts_JobGetTaskCounts()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetJobTaskCounts("jobId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("taskCounts").GetProperty("active").ToString());
            Console.WriteLine(result.GetProperty("taskCounts").GetProperty("running").ToString());
            Console.WriteLine(result.GetProperty("taskCounts").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("taskCounts").GetProperty("succeeded").ToString());
            Console.WriteLine(result.GetProperty("taskCounts").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("taskSlotCounts").GetProperty("active").ToString());
            Console.WriteLine(result.GetProperty("taskSlotCounts").GetProperty("running").ToString());
            Console.WriteLine(result.GetProperty("taskSlotCounts").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("taskSlotCounts").GetProperty("succeeded").ToString());
            Console.WriteLine(result.GetProperty("taskSlotCounts").GetProperty("failed").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetJobTaskCounts_JobGetTaskCounts_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetJobTaskCountsAsync("jobId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("taskCounts").GetProperty("active").ToString());
            Console.WriteLine(result.GetProperty("taskCounts").GetProperty("running").ToString());
            Console.WriteLine(result.GetProperty("taskCounts").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("taskCounts").GetProperty("succeeded").ToString());
            Console.WriteLine(result.GetProperty("taskCounts").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("taskSlotCounts").GetProperty("active").ToString());
            Console.WriteLine(result.GetProperty("taskSlotCounts").GetProperty("running").ToString());
            Console.WriteLine(result.GetProperty("taskSlotCounts").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("taskSlotCounts").GetProperty("succeeded").ToString());
            Console.WriteLine(result.GetProperty("taskSlotCounts").GetProperty("failed").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetJobTaskCounts_JobGetTaskCounts_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchTaskCountsResult> response = client.GetJobTaskCounts("jobId");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetJobTaskCounts_JobGetTaskCounts_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchTaskCountsResult> response = await client.GetJobTaskCountsAsync("jobId");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_DeleteJobSchedule_JobScheduleDelete()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.DeleteJobSchedule("jobScheduleId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_DeleteJobSchedule_JobScheduleDelete_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.DeleteJobScheduleAsync("jobScheduleId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetJobSchedule_JobScheduleGet()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetJobSchedule("jobScheduleId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("jobSpecification").GetProperty("poolInfo").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetJobSchedule_JobScheduleGet_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetJobScheduleAsync("jobScheduleId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("jobSpecification").GetProperty("poolInfo").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetJobSchedule_JobScheduleGet_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchJobSchedule> response = client.GetJobSchedule("jobScheduleId");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetJobSchedule_JobScheduleGet_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchJobSchedule> response = await client.GetJobScheduleAsync("jobScheduleId");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_UpdateJobSchedule_JobSchedulePatch()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                schedule = new
                {
                    doNotRunUntil = "2025-01-01T12:30:00Z",
                },
                jobSpecification = new
                {
                    priority = 0,
                    usesTaskDependencies = false,
                    constraints = new
                    {
                        maxWallClockTime = "P10675199DT2H48M5.4775807S",
                        maxTaskRetryCount = 0,
                    },
                    poolInfo = new
                    {
                        poolId = "poolId",
                    },
                },
            });
            Response response = client.UpdateJobSchedule("jobScheduleId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_UpdateJobSchedule_JobSchedulePatch_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                schedule = new
                {
                    doNotRunUntil = "2025-01-01T12:30:00Z",
                },
                jobSpecification = new
                {
                    priority = 0,
                    usesTaskDependencies = false,
                    constraints = new
                    {
                        maxWallClockTime = "P10675199DT2H48M5.4775807S",
                        maxTaskRetryCount = 0,
                    },
                    poolInfo = new
                    {
                        poolId = "poolId",
                    },
                },
            });
            Response response = await client.UpdateJobScheduleAsync("jobScheduleId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_ReplaceJobSchedule_JobScheduleUpdate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                schedule = new
                {
                    doNotRunUntil = "2025-01-01T12:30:00Z",
                },
                jobSpecification = new
                {
                    priority = 0,
                    usesTaskDependencies = false,
                    constraints = new
                    {
                        maxWallClockTime = "P10675199DT2H48M5.4775807S",
                        maxTaskRetryCount = 0,
                    },
                    poolInfo = new
                    {
                        poolId = "poolId",
                    },
                },
            });
            Response response = client.ReplaceJobSchedule("jobScheduleId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_ReplaceJobSchedule_JobScheduleUpdate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                schedule = new
                {
                    doNotRunUntil = "2025-01-01T12:30:00Z",
                },
                jobSpecification = new
                {
                    priority = 0,
                    usesTaskDependencies = false,
                    constraints = new
                    {
                        maxWallClockTime = "P10675199DT2H48M5.4775807S",
                        maxTaskRetryCount = 0,
                    },
                    poolInfo = new
                    {
                        poolId = "poolId",
                    },
                },
            });
            Response response = await client.ReplaceJobScheduleAsync("jobScheduleId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_ReplaceJobSchedule_JobScheduleUpdate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchJobSchedule jobSchedule = new BatchJobSchedule(new BatchJobSpecification(new BatchPoolInfo
            {
                PoolId = "poolId",
            })
            {
                Priority = 0,
                UsesTaskDependencies = false,
                Constraints = new BatchJobConstraints
                {
                    MaxWallClockTime = XmlConvert.ToTimeSpan("P10675199DT2H48M5.4775807S"),
                    MaxTaskRetryCount = 0,
                },
            })
            {
                Schedule = new BatchJobScheduleConfiguration
                {
                    DoNotRunUntil = DateTimeOffset.Parse("2025-01-01T12:30:00Z"),
                },
            };
            Response response = client.ReplaceJobSchedule("jobScheduleId", jobSchedule);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_ReplaceJobSchedule_JobScheduleUpdate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchJobSchedule jobSchedule = new BatchJobSchedule(new BatchJobSpecification(new BatchPoolInfo
            {
                PoolId = "poolId",
            })
            {
                Priority = 0,
                UsesTaskDependencies = false,
                Constraints = new BatchJobConstraints
                {
                    MaxWallClockTime = XmlConvert.ToTimeSpan("P10675199DT2H48M5.4775807S"),
                    MaxTaskRetryCount = 0,
                },
            })
            {
                Schedule = new BatchJobScheduleConfiguration
                {
                    DoNotRunUntil = DateTimeOffset.Parse("2025-01-01T12:30:00Z"),
                },
            };
            Response response = await client.ReplaceJobScheduleAsync("jobScheduleId", jobSchedule);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_DisableJobSchedule_JobScheduleDisable()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.DisableJobSchedule("jobScheduleId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_DisableJobSchedule_JobScheduleDisable_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.DisableJobScheduleAsync("jobScheduleId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_EnableJobSchedule_JobScheduleEnable()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.EnableJobSchedule("jobScheduleId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_EnableJobSchedule_JobScheduleEnable_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.EnableJobScheduleAsync("jobScheduleId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_TerminateJobSchedule_JobScheduleTerminate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.TerminateJobSchedule("jobScheduleId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_TerminateJobSchedule_JobScheduleTerminate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.TerminateJobScheduleAsync("jobScheduleId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateJobSchedule_CreatesABasicJobSchedule()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "jobScheduleId",
                schedule = new
                {
                    recurrenceInterval = "PT5M",
                },
                jobSpecification = new
                {
                    poolInfo = new
                    {
                        poolId = "poolId",
                    },
                },
            });
            Response response = client.CreateJobSchedule(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateJobSchedule_CreatesABasicJobSchedule_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "jobScheduleId",
                schedule = new
                {
                    recurrenceInterval = "PT5M",
                },
                jobSpecification = new
                {
                    poolInfo = new
                    {
                        poolId = "poolId",
                    },
                },
            });
            Response response = await client.CreateJobScheduleAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateJobSchedule_CreatesABasicJobSchedule_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchJobScheduleCreateContent jobSchedule = new BatchJobScheduleCreateContent("jobScheduleId", new BatchJobScheduleConfiguration
            {
                RecurrenceInterval = XmlConvert.ToTimeSpan("PT5M"),
            }, new BatchJobSpecification(new BatchPoolInfo
            {
                PoolId = "poolId",
            }));
            Response response = client.CreateJobSchedule(jobSchedule);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateJobSchedule_CreatesABasicJobSchedule_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchJobScheduleCreateContent jobSchedule = new BatchJobScheduleCreateContent("jobScheduleId", new BatchJobScheduleConfiguration
            {
                RecurrenceInterval = XmlConvert.ToTimeSpan("PT5M"),
            }, new BatchJobSpecification(new BatchPoolInfo
            {
                PoolId = "poolId",
            }));
            Response response = await client.CreateJobScheduleAsync(jobSchedule);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateJobSchedule_CreatesAComplexJobScheduleAdd()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "jobScheduleId",
                schedule = new
                {
                    doNotRunUntil = "2014-09-10T02:30:00.000Z",
                    doNotRunAfter = "2014-09-10T06:30:00.000Z",
                    startWindow = "PT1M",
                    recurrenceInterval = "PT5M",
                },
                jobSpecification = new
                {
                    priority = 100,
                    constraints = new
                    {
                        maxWallClockTime = "PT1H",
                        maxTaskRetryCount = -1,
                    },
                    jobManagerTask = new
                    {
                        id = "mytask1",
                        commandLine = "myprogram.exe",
                        resourceFiles = new object[]
            {
new
{
httpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram.exe?sas",
filePath = "myprogram.exe",
},
new
{
httpUrl = "http://mystorage1.blob.core.windows.net/scripts/test.txt?sas",
filePath = "test.txt",
}
            },
                        environmentSettings = new object[]
            {
new
{
name = "myvariable",
value = "myvalue",
}
            },
                        constraints = new
                        {
                            maxWallClockTime = "PT1H",
                            maxTaskRetryCount = 0,
                            retentionTime = "PT1H",
                        },
                        requiredSlots = 2,
                        killJobOnCompletion = true,
                        userIdentity = new
                        {
                            autoUser = new
                            {
                                scope = "task",
                                elevationLevel = "nonadmin",
                            },
                        },
                        runExclusive = true,
                    },
                    poolInfo = new
                    {
                        autoPoolSpecification = new
                        {
                            autoPoolIdPrefix = "mypool",
                            poolLifetimeOption = "jobschedule",
                            pool = new
                            {
                                vmSize = "Standard_D1_v2",
                                virtualMachineConfiguration = new
                                {
                                    imageReference = new
                                    {
                                        publisher = "MicrosoftWindowsServer",
                                        offer = "WindowsServer",
                                        sku = "2016-datacenter-smalldisk",
                                        version = "latest",
                                    },
                                    nodeAgentSKUId = "batch.node.windows amd64",
                                },
                                resizeTimeout = "PT15M",
                                targetDedicatedNodes = 3,
                                targetLowPriorityNodes = 0,
                                taskSlotsPerNode = 2,
                                taskSchedulingPolicy = new
                                {
                                    nodeFillType = "spread",
                                },
                                enableAutoScale = false,
                                enableInterNodeCommunication = true,
                                startTask = new
                                {
                                    commandLine = "myprogram2.exe",
                                    resourceFiles = new object[]
            {
new
{
httpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram2.exe?sas",
filePath = "myprogram2.exe",
}
            },
                                    environmentSettings = new object[]
            {
new
{
name = "myvariable",
value = "myvalue",
}
            },
                                    userIdentity = new
                                    {
                                        autoUser = new
                                        {
                                            scope = "task",
                                            elevationLevel = "admin",
                                        },
                                    },
                                    maxTaskRetryCount = 2,
                                    waitForSuccess = true,
                                },
                                metadata = new object[]
            {
new
{
name = "myproperty",
value = "myvalue",
}
            },
                                targetNodeCommunicationMode = "default",
                            },
                        },
                    },
                },
                metadata = new object[]
            {
new
{
name = "myproperty",
value = "myvalue",
}
            },
            });
            Response response = client.CreateJobSchedule(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateJobSchedule_CreatesAComplexJobScheduleAdd_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "jobScheduleId",
                schedule = new
                {
                    doNotRunUntil = "2014-09-10T02:30:00.000Z",
                    doNotRunAfter = "2014-09-10T06:30:00.000Z",
                    startWindow = "PT1M",
                    recurrenceInterval = "PT5M",
                },
                jobSpecification = new
                {
                    priority = 100,
                    constraints = new
                    {
                        maxWallClockTime = "PT1H",
                        maxTaskRetryCount = -1,
                    },
                    jobManagerTask = new
                    {
                        id = "mytask1",
                        commandLine = "myprogram.exe",
                        resourceFiles = new object[]
            {
new
{
httpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram.exe?sas",
filePath = "myprogram.exe",
},
new
{
httpUrl = "http://mystorage1.blob.core.windows.net/scripts/test.txt?sas",
filePath = "test.txt",
}
            },
                        environmentSettings = new object[]
            {
new
{
name = "myvariable",
value = "myvalue",
}
            },
                        constraints = new
                        {
                            maxWallClockTime = "PT1H",
                            maxTaskRetryCount = 0,
                            retentionTime = "PT1H",
                        },
                        requiredSlots = 2,
                        killJobOnCompletion = true,
                        userIdentity = new
                        {
                            autoUser = new
                            {
                                scope = "task",
                                elevationLevel = "nonadmin",
                            },
                        },
                        runExclusive = true,
                    },
                    poolInfo = new
                    {
                        autoPoolSpecification = new
                        {
                            autoPoolIdPrefix = "mypool",
                            poolLifetimeOption = "jobschedule",
                            pool = new
                            {
                                vmSize = "Standard_D1_v2",
                                virtualMachineConfiguration = new
                                {
                                    imageReference = new
                                    {
                                        publisher = "MicrosoftWindowsServer",
                                        offer = "WindowsServer",
                                        sku = "2016-datacenter-smalldisk",
                                        version = "latest",
                                    },
                                    nodeAgentSKUId = "batch.node.windows amd64",
                                },
                                resizeTimeout = "PT15M",
                                targetDedicatedNodes = 3,
                                targetLowPriorityNodes = 0,
                                taskSlotsPerNode = 2,
                                taskSchedulingPolicy = new
                                {
                                    nodeFillType = "spread",
                                },
                                enableAutoScale = false,
                                enableInterNodeCommunication = true,
                                startTask = new
                                {
                                    commandLine = "myprogram2.exe",
                                    resourceFiles = new object[]
            {
new
{
httpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram2.exe?sas",
filePath = "myprogram2.exe",
}
            },
                                    environmentSettings = new object[]
            {
new
{
name = "myvariable",
value = "myvalue",
}
            },
                                    userIdentity = new
                                    {
                                        autoUser = new
                                        {
                                            scope = "task",
                                            elevationLevel = "admin",
                                        },
                                    },
                                    maxTaskRetryCount = 2,
                                    waitForSuccess = true,
                                },
                                metadata = new object[]
            {
new
{
name = "myproperty",
value = "myvalue",
}
            },
                                targetNodeCommunicationMode = "default",
                            },
                        },
                    },
                },
                metadata = new object[]
            {
new
{
name = "myproperty",
value = "myvalue",
}
            },
            });
            Response response = await client.CreateJobScheduleAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateJobSchedule_CreatesAComplexJobScheduleAdd_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchJobScheduleCreateContent jobSchedule = new BatchJobScheduleCreateContent("jobScheduleId", new BatchJobScheduleConfiguration
            {
                DoNotRunUntil = DateTimeOffset.Parse("2014-09-10T02:30:00.000Z"),
                DoNotRunAfter = DateTimeOffset.Parse("2014-09-10T06:30:00.000Z"),
                StartWindow = XmlConvert.ToTimeSpan("PT1M"),
                RecurrenceInterval = XmlConvert.ToTimeSpan("PT5M"),
            }, new BatchJobSpecification(new BatchPoolInfo
            {
                AutoPoolSpecification = new BatchAutoPoolSpecification(BatchPoolLifetimeOption.JobSchedule)
                {
                    AutoPoolIdPrefix = "mypool",
                    Pool = new BatchPoolSpecification("Standard_D1_v2")
                    {
                        VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                        {
                            Publisher = "MicrosoftWindowsServer",
                            Offer = "WindowsServer",
                            Sku = "2016-datacenter-smalldisk",
                            Version = "latest",
                        }, "batch.node.windows amd64"),
                        TaskSlotsPerNode = 2,
                        TaskSchedulingPolicy = new BatchTaskSchedulingPolicy(BatchNodeFillType.Spread),
                        ResizeTimeout = XmlConvert.ToTimeSpan("PT15M"),
                        TargetDedicatedNodes = 3,
                        TargetLowPriorityNodes = 0,
                        EnableAutoScale = false,
                        EnableInterNodeCommunication = true,
                        StartTask = new BatchStartTask("myprogram2.exe")
                        {
                            ResourceFiles = {new ResourceFile
{
HttpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram2.exe?sas",
FilePath = "myprogram2.exe",
}},
                            EnvironmentSettings = {new EnvironmentSetting("myvariable")
{
Value = "myvalue",
}},
                            UserIdentity = new UserIdentity
                            {
                                AutoUser = new AutoUserSpecification
                                {
                                    Scope = AutoUserScope.Task,
                                    ElevationLevel = ElevationLevel.Admin,
                                },
                            },
                            MaxTaskRetryCount = 2,
                            WaitForSuccess = true,
                        },
                        Metadata = { new MetadataItem("myproperty", "myvalue") },
                        TargetNodeCommunicationMode = BatchNodeCommunicationMode.Default,
                    },
                },
            })
            {
                Priority = 100,
                Constraints = new BatchJobConstraints
                {
                    MaxWallClockTime = XmlConvert.ToTimeSpan("PT1H"),
                    MaxTaskRetryCount = -1,
                },
                JobManagerTask = new BatchJobManagerTask("mytask1", "myprogram.exe")
                {
                    ResourceFiles = {new ResourceFile
{
HttpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram.exe?sas",
FilePath = "myprogram.exe",
}, new ResourceFile
{
HttpUrl = "http://mystorage1.blob.core.windows.net/scripts/test.txt?sas",
FilePath = "test.txt",
}},
                    EnvironmentSettings = {new EnvironmentSetting("myvariable")
{
Value = "myvalue",
}},
                    Constraints = new BatchTaskConstraints
                    {
                        MaxWallClockTime = XmlConvert.ToTimeSpan("PT1H"),
                        RetentionTime = XmlConvert.ToTimeSpan("PT1H"),
                        MaxTaskRetryCount = 0,
                    },
                    RequiredSlots = 2,
                    KillJobOnCompletion = true,
                    UserIdentity = new UserIdentity
                    {
                        AutoUser = new AutoUserSpecification
                        {
                            Scope = AutoUserScope.Task,
                            ElevationLevel = ElevationLevel.NonAdmin,
                        },
                    },
                    RunExclusive = true,
                },
            })
            {
                Metadata = { new MetadataItem("myproperty", "myvalue") },
            };
            Response response = client.CreateJobSchedule(jobSchedule);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateJobSchedule_CreatesAComplexJobScheduleAdd_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchJobScheduleCreateContent jobSchedule = new BatchJobScheduleCreateContent("jobScheduleId", new BatchJobScheduleConfiguration
            {
                DoNotRunUntil = DateTimeOffset.Parse("2014-09-10T02:30:00.000Z"),
                DoNotRunAfter = DateTimeOffset.Parse("2014-09-10T06:30:00.000Z"),
                StartWindow = XmlConvert.ToTimeSpan("PT1M"),
                RecurrenceInterval = XmlConvert.ToTimeSpan("PT5M"),
            }, new BatchJobSpecification(new BatchPoolInfo
            {
                AutoPoolSpecification = new BatchAutoPoolSpecification(BatchPoolLifetimeOption.JobSchedule)
                {
                    AutoPoolIdPrefix = "mypool",
                    Pool = new BatchPoolSpecification("Standard_D1_v2")
                    {
                        VirtualMachineConfiguration = new VirtualMachineConfiguration(new ImageReference
                        {
                            Publisher = "MicrosoftWindowsServer",
                            Offer = "WindowsServer",
                            Sku = "2016-datacenter-smalldisk",
                            Version = "latest",
                        }, "batch.node.windows amd64"),
                        TaskSlotsPerNode = 2,
                        TaskSchedulingPolicy = new BatchTaskSchedulingPolicy(BatchNodeFillType.Spread),
                        ResizeTimeout = XmlConvert.ToTimeSpan("PT15M"),
                        TargetDedicatedNodes = 3,
                        TargetLowPriorityNodes = 0,
                        EnableAutoScale = false,
                        EnableInterNodeCommunication = true,
                        StartTask = new BatchStartTask("myprogram2.exe")
                        {
                            ResourceFiles = {new ResourceFile
{
HttpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram2.exe?sas",
FilePath = "myprogram2.exe",
}},
                            EnvironmentSettings = {new EnvironmentSetting("myvariable")
{
Value = "myvalue",
}},
                            UserIdentity = new UserIdentity
                            {
                                AutoUser = new AutoUserSpecification
                                {
                                    Scope = AutoUserScope.Task,
                                    ElevationLevel = ElevationLevel.Admin,
                                },
                            },
                            MaxTaskRetryCount = 2,
                            WaitForSuccess = true,
                        },
                        Metadata = { new MetadataItem("myproperty", "myvalue") },
                        TargetNodeCommunicationMode = BatchNodeCommunicationMode.Default,
                    },
                },
            })
            {
                Priority = 100,
                Constraints = new BatchJobConstraints
                {
                    MaxWallClockTime = XmlConvert.ToTimeSpan("PT1H"),
                    MaxTaskRetryCount = -1,
                },
                JobManagerTask = new BatchJobManagerTask("mytask1", "myprogram.exe")
                {
                    ResourceFiles = {new ResourceFile
{
HttpUrl = "http://mystorage1.blob.core.windows.net/scripts/myprogram.exe?sas",
FilePath = "myprogram.exe",
}, new ResourceFile
{
HttpUrl = "http://mystorage1.blob.core.windows.net/scripts/test.txt?sas",
FilePath = "test.txt",
}},
                    EnvironmentSettings = {new EnvironmentSetting("myvariable")
{
Value = "myvalue",
}},
                    Constraints = new BatchTaskConstraints
                    {
                        MaxWallClockTime = XmlConvert.ToTimeSpan("PT1H"),
                        RetentionTime = XmlConvert.ToTimeSpan("PT1H"),
                        MaxTaskRetryCount = 0,
                    },
                    RequiredSlots = 2,
                    KillJobOnCompletion = true,
                    UserIdentity = new UserIdentity
                    {
                        AutoUser = new AutoUserSpecification
                        {
                            Scope = AutoUserScope.Task,
                            ElevationLevel = ElevationLevel.NonAdmin,
                        },
                    },
                    RunExclusive = true,
                },
            })
            {
                Metadata = { new MetadataItem("myproperty", "myvalue") },
            };
            Response response = await client.CreateJobScheduleAsync(jobSchedule);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateTask_CreatesABasicTask()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "task1",
                commandLine = "cmd /c echo task1",
            });
            Response response = client.CreateTask("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateTask_CreatesABasicTask_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "task1",
                commandLine = "cmd /c echo task1",
            });
            Response response = await client.CreateTaskAsync("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateTask_CreatesABasicTask_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchTaskCreateContent task = new BatchTaskCreateContent("task1", "cmd /c echo task1");
            Response response = client.CreateTask("jobId", task);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateTask_CreatesABasicTask_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchTaskCreateContent task = new BatchTaskCreateContent("task1", "cmd /c echo task1");
            Response response = await client.CreateTaskAsync("jobId", task);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateTask_CreatesATaskWithContainerSettings()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "taskId",
                commandLine = "bash -c 'echo hello'",
                containerSettings = new
                {
                    imageName = "ubuntu",
                    containerRunOptions = "--rm",
                },
                userIdentity = new
                {
                    autoUser = new
                    {
                        scope = "task",
                        elevationLevel = "nonadmin",
                    },
                },
            });
            Response response = client.CreateTask("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateTask_CreatesATaskWithContainerSettings_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "taskId",
                commandLine = "bash -c 'echo hello'",
                containerSettings = new
                {
                    imageName = "ubuntu",
                    containerRunOptions = "--rm",
                },
                userIdentity = new
                {
                    autoUser = new
                    {
                        scope = "task",
                        elevationLevel = "nonadmin",
                    },
                },
            });
            Response response = await client.CreateTaskAsync("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateTask_CreatesATaskWithContainerSettings_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchTaskCreateContent task = new BatchTaskCreateContent("taskId", "bash -c 'echo hello'")
            {
                ContainerSettings = new BatchTaskContainerSettings("ubuntu")
                {
                    ContainerRunOptions = "--rm",
                },
                UserIdentity = new UserIdentity
                {
                    AutoUser = new AutoUserSpecification
                    {
                        Scope = AutoUserScope.Task,
                        ElevationLevel = ElevationLevel.NonAdmin,
                    },
                },
            };
            Response response = client.CreateTask("jobId", task);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateTask_CreatesATaskWithContainerSettings_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchTaskCreateContent task = new BatchTaskCreateContent("taskId", "bash -c 'echo hello'")
            {
                ContainerSettings = new BatchTaskContainerSettings("ubuntu")
                {
                    ContainerRunOptions = "--rm",
                },
                UserIdentity = new UserIdentity
                {
                    AutoUser = new AutoUserSpecification
                    {
                        Scope = AutoUserScope.Task,
                        ElevationLevel = ElevationLevel.NonAdmin,
                    },
                },
            };
            Response response = await client.CreateTaskAsync("jobId", task);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateTask_CreatesATaskWithExitConditions()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "taskId",
                commandLine = "cmd /c exit 3",
                exitConditions = new
                {
                    exitCodeRanges = new object[]
            {
new
{
start = 2,
end = 4,
exitOptions = new
{
jobAction = "terminate",
},
}
            },
                },
                userIdentity = new
                {
                    autoUser = new
                    {
                        scope = "task",
                        elevationLevel = "nonadmin",
                    },
                },
            });
            Response response = client.CreateTask("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateTask_CreatesATaskWithExitConditions_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "taskId",
                commandLine = "cmd /c exit 3",
                exitConditions = new
                {
                    exitCodeRanges = new object[]
            {
new
{
start = 2,
end = 4,
exitOptions = new
{
jobAction = "terminate",
},
}
            },
                },
                userIdentity = new
                {
                    autoUser = new
                    {
                        scope = "task",
                        elevationLevel = "nonadmin",
                    },
                },
            });
            Response response = await client.CreateTaskAsync("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateTask_CreatesATaskWithExitConditions_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchTaskCreateContent task = new BatchTaskCreateContent("taskId", "cmd /c exit 3")
            {
                ExitConditions = new ExitConditions
                {
                    ExitCodeRanges = {new ExitCodeRangeMapping(2, 4, new ExitOptions
{
JobAction = BatchJobAction.Terminate,
})},
                },
                UserIdentity = new UserIdentity
                {
                    AutoUser = new AutoUserSpecification
                    {
                        Scope = AutoUserScope.Task,
                        ElevationLevel = ElevationLevel.NonAdmin,
                    },
                },
            };
            Response response = client.CreateTask("jobId", task);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateTask_CreatesATaskWithExitConditions_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchTaskCreateContent task = new BatchTaskCreateContent("taskId", "cmd /c exit 3")
            {
                ExitConditions = new ExitConditions
                {
                    ExitCodeRanges = {new ExitCodeRangeMapping(2, 4, new ExitOptions
{
JobAction = BatchJobAction.Terminate,
})},
                },
                UserIdentity = new UserIdentity
                {
                    AutoUser = new AutoUserSpecification
                    {
                        Scope = AutoUserScope.Task,
                        ElevationLevel = ElevationLevel.NonAdmin,
                    },
                },
            };
            Response response = await client.CreateTaskAsync("jobId", task);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateTask_CreatesATaskWithExtraSlotRequirement()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "task1",
                requiredSlots = 2,
                commandLine = "cmd /c echo task1",
            });
            Response response = client.CreateTask("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateTask_CreatesATaskWithExtraSlotRequirement_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                id = "task1",
                requiredSlots = 2,
                commandLine = "cmd /c echo task1",
            });
            Response response = await client.CreateTaskAsync("jobId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateTask_CreatesATaskWithExtraSlotRequirement_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchTaskCreateContent task = new BatchTaskCreateContent("task1", "cmd /c echo task1")
            {
                RequiredSlots = 2,
            };
            Response response = client.CreateTask("jobId", task);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateTask_CreatesATaskWithExtraSlotRequirement_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchTaskCreateContent task = new BatchTaskCreateContent("task1", "cmd /c echo task1")
            {
                RequiredSlots = 2,
            };
            Response response = await client.CreateTaskAsync("jobId", task);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateTaskCollection_CreatesABasicCollectionOfTasks()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                value = new object[]
            {
new
{
id = "simple1",
commandLine = "cmd /c dir /s",
},
new
{
id = "simple2",
commandLine = "cmd /c dir /s",
}
            },
            });
            Response response = client.CreateTaskCollection("jobId", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateTaskCollection_CreatesABasicCollectionOfTasks_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                value = new object[]
            {
new
{
id = "simple1",
commandLine = "cmd /c dir /s",
},
new
{
id = "simple2",
commandLine = "cmd /c dir /s",
}
            },
            });
            Response response = await client.CreateTaskCollectionAsync("jobId", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateTaskCollection_CreatesABasicCollectionOfTasks_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchTaskGroup taskCollection = new BatchTaskGroup(new BatchTaskCreateContent[]
            {
new BatchTaskCreateContent("simple1", "cmd /c dir /s"),
new BatchTaskCreateContent("simple2", "cmd /c dir /s")
            });
            Response<BatchTaskAddCollectionResult> response = client.CreateTaskCollection("jobId", taskCollection);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateTaskCollection_CreatesABasicCollectionOfTasks_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchTaskGroup taskCollection = new BatchTaskGroup(new BatchTaskCreateContent[]
            {
new BatchTaskCreateContent("simple1", "cmd /c dir /s"),
new BatchTaskCreateContent("simple2", "cmd /c dir /s")
            });
            Response<BatchTaskAddCollectionResult> response = await client.CreateTaskCollectionAsync("jobId", taskCollection);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateTaskCollection_CreatesAComplexCollectionOfTasks()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                value = new object[]
            {
new
{
id = "complex1",
commandLine = "cmd /c dir /s",
resourceFiles = new object[]
{
new
{
autoStorageContainerName = "containerName",
filePath = "data",
}
},
environmentSettings = new object[]
{
new
{
name = "env1",
value = "value1",
},
new
{
name = "env2",
value = "value2",
}
},
affinityInfo = new
{
affinityId = "affinityId",
},
constraints = new
{
maxWallClockTime = "P1D",
retentionTime = "P2D",
maxTaskRetryCount = 5,
},
requiredSlots = 2,
multiInstanceSettings = new
{
numberOfInstances = 3,
coordinationCommandLine = "cmd /c echo coordinating",
commonResourceFiles = new object[]
{
new
{
httpUrl = "https://common.blob.core.windows.net/",
filePath = "common.exe",
}
},
},
},
new
{
id = "simple3",
commandLine = "cmd /c dir /s",
}
            },
            });
            Response response = client.CreateTaskCollection("jobId", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateTaskCollection_CreatesAComplexCollectionOfTasks_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                value = new object[]
            {
new
{
id = "complex1",
commandLine = "cmd /c dir /s",
resourceFiles = new object[]
{
new
{
autoStorageContainerName = "containerName",
filePath = "data",
}
},
environmentSettings = new object[]
{
new
{
name = "env1",
value = "value1",
},
new
{
name = "env2",
value = "value2",
}
},
affinityInfo = new
{
affinityId = "affinityId",
},
constraints = new
{
maxWallClockTime = "P1D",
retentionTime = "P2D",
maxTaskRetryCount = 5,
},
requiredSlots = 2,
multiInstanceSettings = new
{
numberOfInstances = 3,
coordinationCommandLine = "cmd /c echo coordinating",
commonResourceFiles = new object[]
{
new
{
httpUrl = "https://common.blob.core.windows.net/",
filePath = "common.exe",
}
},
},
},
new
{
id = "simple3",
commandLine = "cmd /c dir /s",
}
            },
            });
            Response response = await client.CreateTaskCollectionAsync("jobId", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateTaskCollection_CreatesAComplexCollectionOfTasks_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchTaskGroup taskCollection = new BatchTaskGroup(new BatchTaskCreateContent[]
            {
new BatchTaskCreateContent("complex1", "cmd /c dir /s")
{
ResourceFiles = {new ResourceFile
{
AutoStorageContainerName = "containerName",
FilePath = "data",
}},
EnvironmentSettings = {new EnvironmentSetting("env1")
{
Value = "value1",
}, new EnvironmentSetting("env2")
{
Value = "value2",
}},
AffinityInfo = new AffinityInfo("affinityId"),
Constraints = new BatchTaskConstraints
{
MaxWallClockTime = XmlConvert.ToTimeSpan("P1D"),
RetentionTime = XmlConvert.ToTimeSpan("P2D"),
MaxTaskRetryCount = 5,
},
RequiredSlots = 2,
MultiInstanceSettings = new MultiInstanceSettings("cmd /c echo coordinating")
{
NumberOfInstances = 3,
CommonResourceFiles = {new ResourceFile
{
HttpUrl = "https://common.blob.core.windows.net/",
FilePath = "common.exe",
}},
},
},
new BatchTaskCreateContent("simple3", "cmd /c dir /s")
            });
            Response<BatchTaskAddCollectionResult> response = client.CreateTaskCollection("jobId", taskCollection);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateTaskCollection_CreatesAComplexCollectionOfTasks_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchTaskGroup taskCollection = new BatchTaskGroup(new BatchTaskCreateContent[]
            {
new BatchTaskCreateContent("complex1", "cmd /c dir /s")
{
ResourceFiles = {new ResourceFile
{
AutoStorageContainerName = "containerName",
FilePath = "data",
}},
EnvironmentSettings = {new EnvironmentSetting("env1")
{
Value = "value1",
}, new EnvironmentSetting("env2")
{
Value = "value2",
}},
AffinityInfo = new AffinityInfo("affinityId"),
Constraints = new BatchTaskConstraints
{
MaxWallClockTime = XmlConvert.ToTimeSpan("P1D"),
RetentionTime = XmlConvert.ToTimeSpan("P2D"),
MaxTaskRetryCount = 5,
},
RequiredSlots = 2,
MultiInstanceSettings = new MultiInstanceSettings("cmd /c echo coordinating")
{
NumberOfInstances = 3,
CommonResourceFiles = {new ResourceFile
{
HttpUrl = "https://common.blob.core.windows.net/",
FilePath = "common.exe",
}},
},
},
new BatchTaskCreateContent("simple3", "cmd /c dir /s")
            });
            Response<BatchTaskAddCollectionResult> response = await client.CreateTaskCollectionAsync("jobId", taskCollection);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_DeleteTask_TaskDelete()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.DeleteTask("jobId", "taskId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_DeleteTask_TaskDelete_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.DeleteTaskAsync("jobId", "taskId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetTask_TaskGet()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetTask("jobId", "taskId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetTask_TaskGet_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetTaskAsync("jobId", "taskId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetTask_TaskGet_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchTask> response = client.GetTask("jobId", "taskId");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetTask_TaskGet_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchTask> response = await client.GetTaskAsync("jobId", "taskId");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_ReplaceTask_TaskUpdate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                constraints = new
                {
                    maxWallClockTime = "PT1H",
                    maxTaskRetryCount = 3,
                    retentionTime = "PT1H",
                },
            });
            Response response = client.ReplaceTask("jobId", "taskId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_ReplaceTask_TaskUpdate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                constraints = new
                {
                    maxWallClockTime = "PT1H",
                    maxTaskRetryCount = 3,
                    retentionTime = "PT1H",
                },
            });
            Response response = await client.ReplaceTaskAsync("jobId", "taskId", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_ReplaceTask_TaskUpdate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchTask task = new BatchTask
            {
                Constraints = new BatchTaskConstraints
                {
                    MaxWallClockTime = XmlConvert.ToTimeSpan("PT1H"),
                    RetentionTime = XmlConvert.ToTimeSpan("PT1H"),
                    MaxTaskRetryCount = 3,
                },
            };
            Response response = client.ReplaceTask("jobId", "taskId", task);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_ReplaceTask_TaskUpdate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchTask task = new BatchTask
            {
                Constraints = new BatchTaskConstraints
                {
                    MaxWallClockTime = XmlConvert.ToTimeSpan("PT1H"),
                    RetentionTime = XmlConvert.ToTimeSpan("PT1H"),
                    MaxTaskRetryCount = 3,
                },
            };
            Response response = await client.ReplaceTaskAsync("jobId", "taskId", task);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_TerminateTask_TaskTerminate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.TerminateTask("jobId", "taskId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_TerminateTask_TaskTerminate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.TerminateTaskAsync("jobId", "taskId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_ReactivateTask_TaskReactivate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.ReactivateTask("jobId", "taskId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_ReactivateTask_TaskReactivate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.ReactivateTaskAsync("jobId", "taskId");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_DeleteTaskFile_FileDeleteFromTask()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.DeleteTaskFile("jobId", "task1", "wd\\testFile.txt");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_DeleteTaskFile_FileDeleteFromTask_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.DeleteTaskFileAsync("jobId", "task1", "wd\\testFile.txt");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetTaskFile_GetFileFromTask()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetTaskFile("jobId", "task1", "wd\\testFile.txt", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetTaskFile_GetFileFromTask_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetTaskFileAsync("jobId", "task1", "wd\\testFile.txt", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetTaskFile_GetFileFromTask_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BinaryData> response = client.GetTaskFile("jobId", "task1", "wd\\testFile.txt");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetTaskFile_GetFileFromTask_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BinaryData> response = await client.GetTaskFileAsync("jobId", "task1", "wd\\testFile.txt");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateNodeUser_NodeCreateUser()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                name = "userName",
                isAdmin = false,
                expiryTime = "2017-08-01T00:00:00Z",
                password = "Password",
            });
            Response response = client.CreateNodeUser("poolId", "tvm-1695681911_1-20161121t182739z", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateNodeUser_NodeCreateUser_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                name = "userName",
                isAdmin = false,
                expiryTime = "2017-08-01T00:00:00Z",
                password = "Password",
            });
            Response response = await client.CreateNodeUserAsync("poolId", "tvm-1695681911_1-20161121t182739z", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_CreateNodeUser_NodeCreateUser_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchNodeUserCreateContent user = new BatchNodeUserCreateContent("userName")
            {
                IsAdmin = false,
                ExpiryTime = DateTimeOffset.Parse("2017-08-01T00:00:00Z"),
                Password = "Password",
            };
            Response response = client.CreateNodeUser("poolId", "tvm-1695681911_1-20161121t182739z", user);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_CreateNodeUser_NodeCreateUser_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchNodeUserCreateContent user = new BatchNodeUserCreateContent("userName")
            {
                IsAdmin = false,
                ExpiryTime = DateTimeOffset.Parse("2017-08-01T00:00:00Z"),
                Password = "Password",
            };
            Response response = await client.CreateNodeUserAsync("poolId", "tvm-1695681911_1-20161121t182739z", user);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_DeleteNodeUser_NodeDeleteUser()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.DeleteNodeUser("poolId", "tvm-1695681911_1-20161121t182739z", "userName");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_DeleteNodeUser_NodeDeleteUser_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.DeleteNodeUserAsync("poolId", "tvm-1695681911_1-20161121t182739z", "userName");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_ReplaceNodeUser_NodeUpdateUser()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                password = "12345",
                expiryTime = "2016-11-27T00:45:48.7320857Z",
            });
            Response response = client.ReplaceNodeUser("poolId", "tvm-1695681911_1-20161121t182739z", "userName", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_ReplaceNodeUser_NodeUpdateUser_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                password = "12345",
                expiryTime = "2016-11-27T00:45:48.7320857Z",
            });
            Response response = await client.ReplaceNodeUserAsync("poolId", "tvm-1695681911_1-20161121t182739z", "userName", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_ReplaceNodeUser_NodeUpdateUser_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchNodeUserUpdateContent content = new BatchNodeUserUpdateContent
            {
                Password = "12345",
                ExpiryTime = DateTimeOffset.Parse("2016-11-27T00:45:48.7320857Z"),
            };
            Response response = client.ReplaceNodeUser("poolId", "tvm-1695681911_1-20161121t182739z", "userName", content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_ReplaceNodeUser_NodeUpdateUser_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            BatchNodeUserUpdateContent content = new BatchNodeUserUpdateContent
            {
                Password = "12345",
                ExpiryTime = DateTimeOffset.Parse("2016-11-27T00:45:48.7320857Z"),
            };
            Response response = await client.ReplaceNodeUserAsync("poolId", "tvm-1695681911_1-20161121t182739z", "userName", content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetNode_NodeGet()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetNode("poolId", "tvm-1695681911_2-20161122t193202z", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetNode_NodeGet_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetNodeAsync("poolId", "tvm-1695681911_2-20161122t193202z", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetNode_NodeGet_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchNode> response = client.GetNode("poolId", "tvm-1695681911_2-20161122t193202z");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetNode_NodeGet_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchNode> response = await client.GetNodeAsync("poolId", "tvm-1695681911_2-20161122t193202z");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_RebootNode_NodeReboot()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = null;
            Response response = client.RebootNode("poolId", "tvm-1695681911_1-20161122t193202z", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_RebootNode_NodeReboot_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = null;
            Response response = await client.RebootNodeAsync("poolId", "tvm-1695681911_1-20161122t193202z", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_RebootNode_NodeReboot_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.RebootNode("poolId", "tvm-1695681911_1-20161122t193202z");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_RebootNode_NodeReboot_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.RebootNodeAsync("poolId", "tvm-1695681911_1-20161122t193202z");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_DisableNodeScheduling_NodeDisableScheduling()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = null;
            Response response = client.DisableNodeScheduling("poolId", "tvm-1695681911_1-20161122t193202z", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_DisableNodeScheduling_NodeDisableScheduling_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = null;
            Response response = await client.DisableNodeSchedulingAsync("poolId", "tvm-1695681911_1-20161122t193202z", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_DisableNodeScheduling_NodeDisableScheduling_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.DisableNodeScheduling("poolId", "tvm-1695681911_1-20161122t193202z");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_DisableNodeScheduling_NodeDisableScheduling_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.DisableNodeSchedulingAsync("poolId", "tvm-1695681911_1-20161122t193202z");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_EnableNodeScheduling_NodeEnableScheduling()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.EnableNodeScheduling("poolId", "tvm-1695681911_1-20161122t193202z");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_EnableNodeScheduling_NodeEnableScheduling_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.EnableNodeSchedulingAsync("poolId", "tvm-1695681911_1-20161122t193202z");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetNodeRemoteLoginSettings_NodeGetRemoteLoginSettings()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetNodeRemoteLoginSettings("poolId", "tvm-1695681911_1-20161121t182739z", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("remoteLoginIPAddress").ToString());
            Console.WriteLine(result.GetProperty("remoteLoginPort").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetNodeRemoteLoginSettings_NodeGetRemoteLoginSettings_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetNodeRemoteLoginSettingsAsync("poolId", "tvm-1695681911_1-20161121t182739z", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("remoteLoginIPAddress").ToString());
            Console.WriteLine(result.GetProperty("remoteLoginPort").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetNodeRemoteLoginSettings_NodeGetRemoteLoginSettings_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchNodeRemoteLoginSettings> response = client.GetNodeRemoteLoginSettings("poolId", "tvm-1695681911_1-20161121t182739z");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetNodeRemoteLoginSettings_NodeGetRemoteLoginSettings_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchNodeRemoteLoginSettings> response = await client.GetNodeRemoteLoginSettingsAsync("poolId", "tvm-1695681911_1-20161121t182739z");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_UploadNodeLogs_UploadBatchServiceLogs()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                containerUrl = "https://somestorageacct.blob.core.windows.net/batch-compute-node-logs?se=2017-12-09T18%3A51%3A00Z&sp=w&sv=2016-05-31&sr=c&sig",
                startTime = "2017-11-27T00:00:00Z",
            });
            Response response = client.UploadNodeLogs("poolId", "tvm-1695681911_1-20161121t182739z", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("virtualDirectoryName").ToString());
            Console.WriteLine(result.GetProperty("numberOfFilesUploaded").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_UploadNodeLogs_UploadBatchServiceLogs_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                containerUrl = "https://somestorageacct.blob.core.windows.net/batch-compute-node-logs?se=2017-12-09T18%3A51%3A00Z&sp=w&sv=2016-05-31&sr=c&sig",
                startTime = "2017-11-27T00:00:00Z",
            });
            Response response = await client.UploadNodeLogsAsync("poolId", "tvm-1695681911_1-20161121t182739z", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("virtualDirectoryName").ToString());
            Console.WriteLine(result.GetProperty("numberOfFilesUploaded").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_UploadNodeLogs_UploadBatchServiceLogs_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            UploadBatchServiceLogsContent content = new UploadBatchServiceLogsContent("https://somestorageacct.blob.core.windows.net/batch-compute-node-logs?se=2017-12-09T18%3A51%3A00Z&sp=w&sv=2016-05-31&sr=c&sig", DateTimeOffset.Parse("2017-11-27T00:00:00Z"));
            Response<UploadBatchServiceLogsResult> response = client.UploadNodeLogs("poolId", "tvm-1695681911_1-20161121t182739z", content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_UploadNodeLogs_UploadBatchServiceLogs_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            UploadBatchServiceLogsContent content = new UploadBatchServiceLogsContent("https://somestorageacct.blob.core.windows.net/batch-compute-node-logs?se=2017-12-09T18%3A51%3A00Z&sp=w&sv=2016-05-31&sr=c&sig", DateTimeOffset.Parse("2017-11-27T00:00:00Z"));
            Response<UploadBatchServiceLogsResult> response = await client.UploadNodeLogsAsync("poolId", "tvm-1695681911_1-20161121t182739z", content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetNodeExtension_GetBatchNodeExtension()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetNodeExtension("poolId", "tvm-1695681911_2-20161122t193202z", "batchNodeExtension", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetNodeExtension_GetBatchNodeExtension_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetNodeExtensionAsync("poolId", "tvm-1695681911_2-20161122t193202z", "batchNodeExtension", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetNodeExtension_GetBatchNodeExtension_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchNodeVMExtension> response = client.GetNodeExtension("poolId", "tvm-1695681911_2-20161122t193202z", "batchNodeExtension");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetNodeExtension_GetBatchNodeExtension_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BatchNodeVMExtension> response = await client.GetNodeExtensionAsync("poolId", "tvm-1695681911_2-20161122t193202z", "batchNodeExtension");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_DeleteNodeFile_FileDeleteFromNode()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.DeleteNodeFile("poolId", "tvm-1695681911_1-20161122t193202z", "workitems\\jobId\\job-1\\task1\\wd\\testFile.txt");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_DeleteNodeFile_FileDeleteFromNode_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.DeleteNodeFileAsync("poolId", "tvm-1695681911_1-20161122t193202z", "workitems\\jobId\\job-1\\task1\\wd\\testFile.txt");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetNodeFile_GetFileFromComputeNode()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = client.GetNodeFile("poolId", "nodeId", "workitems\\jobId\\job-1\\task1\\wd\\testFile.txt", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetNodeFile_GetFileFromComputeNode_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response response = await client.GetNodeFileAsync("poolId", "nodeId", "workitems\\jobId\\job-1\\task1\\wd\\testFile.txt", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetNodeFile_GetFileFromComputeNode_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BinaryData> response = client.GetNodeFile("poolId", "nodeId", "workitems\\jobId\\job-1\\task1\\wd\\testFile.txt");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetNodeFile_GetFileFromComputeNode_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            Response<BinaryData> response = await client.GetNodeFileAsync("poolId", "nodeId", "workitems\\jobId\\job-1\\task1\\wd\\testFile.txt");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetApplications_ListApplications()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetApplications(null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("displayName").ToString());
                Console.WriteLine(result.GetProperty("versions")[0].ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetApplications_ListApplications_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetApplicationsAsync(null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("displayName").ToString());
                Console.WriteLine(result.GetProperty("versions")[0].ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetApplications_ListApplications_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchApplication item in client.GetApplications())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetApplications_ListApplications_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchApplication item in client.GetApplicationsAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPoolUsageMetrics_PoolListUsageMetrics()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetPoolUsageMetrics(null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("poolId").ToString());
                Console.WriteLine(result.GetProperty("startTime").ToString());
                Console.WriteLine(result.GetProperty("endTime").ToString());
                Console.WriteLine(result.GetProperty("vmSize").ToString());
                Console.WriteLine(result.GetProperty("totalCoreHours").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPoolUsageMetrics_PoolListUsageMetrics_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetPoolUsageMetricsAsync(null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("poolId").ToString());
                Console.WriteLine(result.GetProperty("startTime").ToString());
                Console.WriteLine(result.GetProperty("endTime").ToString());
                Console.WriteLine(result.GetProperty("vmSize").ToString());
                Console.WriteLine(result.GetProperty("totalCoreHours").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPoolUsageMetrics_PoolListUsageMetrics_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchPoolUsageMetrics item in client.GetPoolUsageMetrics())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPoolUsageMetrics_PoolListUsageMetrics_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchPoolUsageMetrics item in client.GetPoolUsageMetricsAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPools_PoolList()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetPools(null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPools_PoolList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetPoolsAsync(null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPools_PoolList_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchPool item in client.GetPools())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPools_PoolList_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchPool item in client.GetPoolsAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetSupportedImages_AccountListNodeAgentSkus()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetSupportedImages(null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("nodeAgentSKUId").ToString());
                Console.WriteLine(result.GetProperty("imageReference").ToString());
                Console.WriteLine(result.GetProperty("osType").ToString());
                Console.WriteLine(result.GetProperty("verificationType").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetSupportedImages_AccountListNodeAgentSkus_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetSupportedImagesAsync(null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("nodeAgentSKUId").ToString());
                Console.WriteLine(result.GetProperty("imageReference").ToString());
                Console.WriteLine(result.GetProperty("osType").ToString());
                Console.WriteLine(result.GetProperty("verificationType").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetSupportedImages_AccountListNodeAgentSkus_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchSupportedImage item in client.GetSupportedImages())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetSupportedImages_AccountListNodeAgentSkus_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchSupportedImage item in client.GetSupportedImagesAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPoolNodeCounts_NodeCountsPayload()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetPoolNodeCounts(null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("poolId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPoolNodeCounts_NodeCountsPayload_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetPoolNodeCountsAsync(null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("poolId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetPoolNodeCounts_NodeCountsPayload_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchPoolNodeCounts item in client.GetPoolNodeCounts())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetPoolNodeCounts_NodeCountsPayload_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchPoolNodeCounts item in client.GetPoolNodeCountsAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetJobs_JobList()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetJobs(null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("poolInfo").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetJobs_JobList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetJobsAsync(null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("poolInfo").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetJobs_JobList_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchJob item in client.GetJobs())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetJobs_JobList_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchJob item in client.GetJobsAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetJobsFromSchedules_ListJobUnderJobSchedule()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetJobsFromSchedules("jobScheduleId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("poolInfo").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetJobsFromSchedules_ListJobUnderJobSchedule_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetJobsFromSchedulesAsync("jobScheduleId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("poolInfo").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetJobsFromSchedules_ListJobUnderJobSchedule_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchJob item in client.GetJobsFromSchedules("jobScheduleId"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetJobsFromSchedules_ListJobUnderJobSchedule_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchJob item in client.GetJobsFromSchedulesAsync("jobScheduleId"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetJobPreparationAndReleaseTaskStatuses_JobListPreparationAndReleaseTaskStatus()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetJobPreparationAndReleaseTaskStatuses("jobId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetJobPreparationAndReleaseTaskStatuses_JobListPreparationAndReleaseTaskStatus_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetJobPreparationAndReleaseTaskStatusesAsync("jobId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetJobPreparationAndReleaseTaskStatuses_JobListPreparationAndReleaseTaskStatus_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchJobPreparationAndReleaseTaskStatus item in client.GetJobPreparationAndReleaseTaskStatuses("jobId"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetJobPreparationAndReleaseTaskStatuses_JobListPreparationAndReleaseTaskStatus_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchJobPreparationAndReleaseTaskStatus item in client.GetJobPreparationAndReleaseTaskStatusesAsync("jobId"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetJobSchedules_JobScheduleList()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetJobSchedules(null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("jobSpecification").GetProperty("poolInfo").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetJobSchedules_JobScheduleList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetJobSchedulesAsync(null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("jobSpecification").GetProperty("poolInfo").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetJobSchedules_JobScheduleList_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchJobSchedule item in client.GetJobSchedules())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetJobSchedules_JobScheduleList_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchJobSchedule item in client.GetJobSchedulesAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetTasks_TaskList()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetTasks("jobId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetTasks_TaskList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetTasksAsync("jobId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetTasks_TaskList_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchTask item in client.GetTasks("jobId"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetTasks_TaskList_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchTask item in client.GetTasksAsync("jobId"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetSubTasks_TaskListSubtasks()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetSubTasks("jobId", "taskId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetSubTasks_TaskListSubtasks_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetSubTasksAsync("jobId", "taskId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetSubTasks_TaskListSubtasks_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchSubtask item in client.GetSubTasks("jobId", "taskId"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetSubTasks_TaskListSubtasks_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchSubtask item in client.GetSubTasksAsync("jobId", "taskId"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetTaskFiles_FileListFromTask()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetTaskFiles("jobId", "taskId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, false, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetTaskFiles_FileListFromTask_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetTaskFilesAsync("jobId", "taskId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, false, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetTaskFiles_FileListFromTask_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchNodeFile item in client.GetTaskFiles("jobId", "taskId"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetTaskFiles_FileListFromTask_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchNodeFile item in client.GetTaskFilesAsync("jobId", "taskId"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetNodes_NodeList()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetNodes("poolId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetNodes_NodeList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetNodesAsync("poolId", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetNodes_NodeList_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchNode item in client.GetNodes("poolId"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetNodes_NodeList_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchNode item in client.GetNodesAsync("poolId"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetNodeExtensions_ListComputeNodeExtensions()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetNodeExtensions("poolId", "tvm-1695681911_2-20161122t193202z", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetNodeExtensions_ListComputeNodeExtensions_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetNodeExtensionsAsync("poolId", "tvm-1695681911_2-20161122t193202z", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetNodeExtensions_ListComputeNodeExtensions_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchNodeVMExtension item in client.GetNodeExtensions("poolId", "tvm-1695681911_2-20161122t193202z"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetNodeExtensions_ListComputeNodeExtensions_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchNodeVMExtension item in client.GetNodeExtensionsAsync("poolId", "tvm-1695681911_2-20161122t193202z"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetNodeFiles_FileListFromNode()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BinaryData item in client.GetNodeFiles("poolId", "tvm-1695681911_1-20161122t193202z", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, false, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetNodeFiles_FileListFromNode_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BinaryData item in client.GetNodeFilesAsync("poolId", "tvm-1695681911_1-20161122t193202z", null, DateTimeOffset.Parse("Fri, 17 Feb 2017 00:00:00 GMT"), null, null, false, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Batch_GetNodeFiles_FileListFromNode_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            foreach (BatchNodeFile item in client.GetNodeFiles("poolId", "tvm-1695681911_1-20161122t193202z"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Batch_GetNodeFiles_FileListFromNode_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            BatchClient client = new BatchClient(endpoint, credential);

            await foreach (BatchNodeFile item in client.GetNodeFilesAsync("poolId", "tvm-1695681911_1-20161122t193202z"))
            {
            }
        }
    }
}
