// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> The vm extension instance view. </summary>
    public partial class VMExtensionInstanceView
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VMExtensionInstanceView"/>. </summary>
        internal VMExtensionInstanceView()
        {
            Statuses = new ChangeTrackingList<InstanceViewStatus>();
            SubStatuses = new ChangeTrackingList<InstanceViewStatus>();
        }

        /// <summary> Initializes a new instance of <see cref="VMExtensionInstanceView"/>. </summary>
        /// <param name="name"> The name of the vm extension instance view. </param>
        /// <param name="statuses"> The resource status information. </param>
        /// <param name="subStatuses"> The resource status information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VMExtensionInstanceView(string name, IReadOnlyList<InstanceViewStatus> statuses, IReadOnlyList<InstanceViewStatus> subStatuses, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Statuses = statuses;
            SubStatuses = subStatuses;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the vm extension instance view. </summary>
        public string Name { get; }
        /// <summary> The resource status information. </summary>
        public IReadOnlyList<InstanceViewStatus> Statuses { get; }
        /// <summary> The resource status information. </summary>
        public IReadOnlyList<InstanceViewStatus> SubStatuses { get; }
    }
}
