// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> The definition of the user identity under which the Task is run. Specify either the userName or autoUser property, but not both. </summary>
    public partial class UserIdentity
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UserIdentity"/>. </summary>
        public UserIdentity()
        {
        }

        /// <summary> Initializes a new instance of <see cref="UserIdentity"/>. </summary>
        /// <param name="username"> The name of the user identity under which the Task is run. The userName and autoUser properties are mutually exclusive; you must specify one but not both. </param>
        /// <param name="autoUser"> The auto user under which the Task is run. The userName and autoUser properties are mutually exclusive; you must specify one but not both. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UserIdentity(string username, AutoUserSpecification autoUser, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Username = username;
            AutoUser = autoUser;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the user identity under which the Task is run. The userName and autoUser properties are mutually exclusive; you must specify one but not both. </summary>
        public string Username { get; set; }
        /// <summary> The auto user under which the Task is run. The userName and autoUser properties are mutually exclusive; you must specify one but not both. </summary>
        public AutoUserSpecification AutoUser { get; set; }
    }
}
