// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> Specifies the SecurityType of the virtual machine. It has to be set to any specified value to enable UefiSettings. </summary>
    public readonly partial struct SecurityTypes : IEquatable<SecurityTypes>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecurityTypes"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecurityTypes(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrustedLaunchValue = "trustedLaunch";

        /// <summary> Trusted launch protects against advanced and persistent attack techniques. </summary>
        public static SecurityTypes TrustedLaunch { get; } = new SecurityTypes(TrustedLaunchValue);
        /// <summary> Determines if two <see cref="SecurityTypes"/> values are the same. </summary>
        public static bool operator ==(SecurityTypes left, SecurityTypes right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecurityTypes"/> values are not the same. </summary>
        public static bool operator !=(SecurityTypes left, SecurityTypes right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecurityTypes"/>. </summary>
        public static implicit operator SecurityTypes(string value) => new SecurityTypes(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecurityTypes other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecurityTypes other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
