// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> SchedulingState enums. </summary>
    public readonly partial struct SchedulingState : IEquatable<SchedulingState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SchedulingState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SchedulingState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "enabled";
        private const string DisabledValue = "disabled";

        /// <summary> Tasks can be scheduled on the Compute Node. </summary>
        public static SchedulingState Enabled { get; } = new SchedulingState(EnabledValue);
        /// <summary> No new Tasks will be scheduled on the Compute Node. Tasks already running on the Compute Node may still run to completion. All Compute Nodes start with scheduling enabled. </summary>
        public static SchedulingState Disabled { get; } = new SchedulingState(DisabledValue);
        /// <summary> Determines if two <see cref="SchedulingState"/> values are the same. </summary>
        public static bool operator ==(SchedulingState left, SchedulingState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SchedulingState"/> values are not the same. </summary>
        public static bool operator !=(SchedulingState left, SchedulingState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SchedulingState"/>. </summary>
        public static implicit operator SchedulingState(string value) => new SchedulingState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SchedulingState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SchedulingState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
