// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Compute.Batch
{
    public partial class ResourceFile : IUtf8JsonSerializable, IJsonModel<ResourceFile>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ResourceFile>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ResourceFile>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceFile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResourceFile)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AutoStorageContainerName))
            {
                writer.WritePropertyName("autoStorageContainerName"u8);
                writer.WriteStringValue(AutoStorageContainerName);
            }
            if (Optional.IsDefined(StorageContainerUrl))
            {
                writer.WritePropertyName("storageContainerUrl"u8);
                writer.WriteStringValue(StorageContainerUrl);
            }
            if (Optional.IsDefined(HttpUrl))
            {
                writer.WritePropertyName("httpUrl"u8);
                writer.WriteStringValue(HttpUrl);
            }
            if (Optional.IsDefined(BlobPrefix))
            {
                writer.WritePropertyName("blobPrefix"u8);
                writer.WriteStringValue(BlobPrefix);
            }
            if (Optional.IsDefined(FilePath))
            {
                writer.WritePropertyName("filePath"u8);
                writer.WriteStringValue(FilePath);
            }
            if (Optional.IsDefined(FileMode))
            {
                writer.WritePropertyName("fileMode"u8);
                writer.WriteStringValue(FileMode);
            }
            if (Optional.IsDefined(IdentityReference))
            {
                writer.WritePropertyName("identityReference"u8);
                writer.WriteObjectValue(IdentityReference, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ResourceFile IJsonModel<ResourceFile>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceFile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResourceFile)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeResourceFile(document.RootElement, options);
        }

        internal static ResourceFile DeserializeResourceFile(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string autoStorageContainerName = default;
            string storageContainerUrl = default;
            string httpUrl = default;
            string blobPrefix = default;
            string filePath = default;
            string fileMode = default;
            BatchNodeIdentityReference identityReference = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("autoStorageContainerName"u8))
                {
                    autoStorageContainerName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("storageContainerUrl"u8))
                {
                    storageContainerUrl = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("httpUrl"u8))
                {
                    httpUrl = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("blobPrefix"u8))
                {
                    blobPrefix = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("filePath"u8))
                {
                    filePath = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fileMode"u8))
                {
                    fileMode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("identityReference"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identityReference = BatchNodeIdentityReference.DeserializeBatchNodeIdentityReference(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ResourceFile(
                autoStorageContainerName,
                storageContainerUrl,
                httpUrl,
                blobPrefix,
                filePath,
                fileMode,
                identityReference,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ResourceFile>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceFile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ResourceFile)} does not support writing '{options.Format}' format.");
            }
        }

        ResourceFile IPersistableModel<ResourceFile>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceFile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeResourceFile(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ResourceFile)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ResourceFile>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ResourceFile FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeResourceFile(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
