// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> OutputFileUploadCondition enums. </summary>
    public readonly partial struct OutputFileUploadCondition : IEquatable<OutputFileUploadCondition>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OutputFileUploadCondition"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OutputFileUploadCondition(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TaskSuccessValue = "tasksuccess";
        private const string TaskFailureValue = "taskfailure";
        private const string TaskCompletionValue = "taskcompletion";

        /// <summary> Upload the file(s) only after the Task process exits with an exit code of 0. </summary>
        public static OutputFileUploadCondition TaskSuccess { get; } = new OutputFileUploadCondition(TaskSuccessValue);
        /// <summary> Upload the file(s) only after the Task process exits with a nonzero exit code. </summary>
        public static OutputFileUploadCondition TaskFailure { get; } = new OutputFileUploadCondition(TaskFailureValue);
        /// <summary> Upload the file(s) after the Task process exits, no matter what the exit code was. </summary>
        public static OutputFileUploadCondition TaskCompletion { get; } = new OutputFileUploadCondition(TaskCompletionValue);
        /// <summary> Determines if two <see cref="OutputFileUploadCondition"/> values are the same. </summary>
        public static bool operator ==(OutputFileUploadCondition left, OutputFileUploadCondition right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OutputFileUploadCondition"/> values are not the same. </summary>
        public static bool operator !=(OutputFileUploadCondition left, OutputFileUploadCondition right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OutputFileUploadCondition"/>. </summary>
        public static implicit operator OutputFileUploadCondition(string value) => new OutputFileUploadCondition(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OutputFileUploadCondition other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OutputFileUploadCondition other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
