// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> OnTaskFailure enums. </summary>
    public readonly partial struct OnBatchTaskFailure : IEquatable<OnBatchTaskFailure>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OnBatchTaskFailure"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OnBatchTaskFailure(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoActionValue = "noaction";
        private const string PerformExitOptionsJobActionValue = "performexitoptionsjobaction";

        /// <summary> Do nothing. The Job remains active unless terminated or disabled by some other means. </summary>
        public static OnBatchTaskFailure NoAction { get; } = new OnBatchTaskFailure(NoActionValue);
        /// <summary> Terminate the Job. The Job's terminationReason is set to 'AllTasksComplete'. </summary>
        public static OnBatchTaskFailure PerformExitOptionsJobAction { get; } = new OnBatchTaskFailure(PerformExitOptionsJobActionValue);
        /// <summary> Determines if two <see cref="OnBatchTaskFailure"/> values are the same. </summary>
        public static bool operator ==(OnBatchTaskFailure left, OnBatchTaskFailure right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OnBatchTaskFailure"/> values are not the same. </summary>
        public static bool operator !=(OnBatchTaskFailure left, OnBatchTaskFailure right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OnBatchTaskFailure"/>. </summary>
        public static implicit operator OnBatchTaskFailure(string value) => new OnBatchTaskFailure(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OnBatchTaskFailure other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OnBatchTaskFailure other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
