// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> OSType enums. </summary>
    public readonly partial struct OSType : IEquatable<OSType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OSType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OSType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LinuxValue = "linux";
        private const string WindowsValue = "windows";

        /// <summary> The Linux operating system. </summary>
        public static OSType Linux { get; } = new OSType(LinuxValue);
        /// <summary> The Windows operating system. </summary>
        public static OSType Windows { get; } = new OSType(WindowsValue);
        /// <summary> Determines if two <see cref="OSType"/> values are the same. </summary>
        public static bool operator ==(OSType left, OSType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OSType"/> values are not the same. </summary>
        public static bool operator !=(OSType left, OSType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OSType"/>. </summary>
        public static implicit operator OSType(string value) => new OSType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OSType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OSType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
