// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> NetworkSecurityGroupRuleAccess enums. </summary>
    public readonly partial struct NetworkSecurityGroupRuleAccess : IEquatable<NetworkSecurityGroupRuleAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityGroupRuleAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkSecurityGroupRuleAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "allow";
        private const string DenyValue = "deny";

        /// <summary> Allow access. </summary>
        public static NetworkSecurityGroupRuleAccess Allow { get; } = new NetworkSecurityGroupRuleAccess(AllowValue);
        /// <summary> Deny access. </summary>
        public static NetworkSecurityGroupRuleAccess Deny { get; } = new NetworkSecurityGroupRuleAccess(DenyValue);
        /// <summary> Determines if two <see cref="NetworkSecurityGroupRuleAccess"/> values are the same. </summary>
        public static bool operator ==(NetworkSecurityGroupRuleAccess left, NetworkSecurityGroupRuleAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkSecurityGroupRuleAccess"/> values are not the same. </summary>
        public static bool operator !=(NetworkSecurityGroupRuleAccess left, NetworkSecurityGroupRuleAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkSecurityGroupRuleAccess"/>. </summary>
        public static implicit operator NetworkSecurityGroupRuleAccess(string value) => new NetworkSecurityGroupRuleAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkSecurityGroupRuleAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkSecurityGroupRuleAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
