// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary>
    /// Multi-instance Tasks are commonly used to support MPI Tasks. In the MPI case,
    /// if any of the subtasks fail (for example due to exiting with a non-zero exit
    /// code) the entire multi-instance Task fails. The multi-instance Task is then
    /// terminated and retried, up to its retry limit.
    /// </summary>
    public partial class MultiInstanceSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MultiInstanceSettings"/>. </summary>
        /// <param name="coordinationCommandLine"> The command line to run on all the Compute Nodes to enable them to coordinate when the primary runs the main Task command. A typical coordination command line launches a background service and verifies that the service is ready to process inter-node messages. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="coordinationCommandLine"/> is null. </exception>
        public MultiInstanceSettings(string coordinationCommandLine)
        {
            Argument.AssertNotNull(coordinationCommandLine, nameof(coordinationCommandLine));

            CoordinationCommandLine = coordinationCommandLine;
            CommonResourceFiles = new ChangeTrackingList<ResourceFile>();
        }

        /// <summary> Initializes a new instance of <see cref="MultiInstanceSettings"/>. </summary>
        /// <param name="numberOfInstances"> The number of Compute Nodes required by the Task. If omitted, the default is 1. </param>
        /// <param name="coordinationCommandLine"> The command line to run on all the Compute Nodes to enable them to coordinate when the primary runs the main Task command. A typical coordination command line launches a background service and verifies that the service is ready to process inter-node messages. </param>
        /// <param name="commonResourceFiles"> A list of files that the Batch service will download before running the coordination command line. The difference between common resource files and Task resource files is that common resource files are downloaded for all subtasks including the primary, whereas Task resource files are downloaded only for the primary. Also note that these resource files are not downloaded to the Task working directory, but instead are downloaded to the Task root directory (one directory above the working directory).  There is a maximum size for the list of resource files.  When the max size is exceeded, the request will fail and the response error code will be RequestEntityTooLarge. If this occurs, the collection of ResourceFiles must be reduced in size. This can be achieved using .zip files, Application Packages, or Docker Containers. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MultiInstanceSettings(int? numberOfInstances, string coordinationCommandLine, IList<ResourceFile> commonResourceFiles, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NumberOfInstances = numberOfInstances;
            CoordinationCommandLine = coordinationCommandLine;
            CommonResourceFiles = commonResourceFiles;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MultiInstanceSettings"/> for deserialization. </summary>
        internal MultiInstanceSettings()
        {
        }

        /// <summary> The number of Compute Nodes required by the Task. If omitted, the default is 1. </summary>
        public int? NumberOfInstances { get; set; }
        /// <summary> The command line to run on all the Compute Nodes to enable them to coordinate when the primary runs the main Task command. A typical coordination command line launches a background service and verifies that the service is ready to process inter-node messages. </summary>
        public string CoordinationCommandLine { get; set; }
        /// <summary> A list of files that the Batch service will download before running the coordination command line. The difference between common resource files and Task resource files is that common resource files are downloaded for all subtasks including the primary, whereas Task resource files are downloaded only for the primary. Also note that these resource files are not downloaded to the Task working directory, but instead are downloaded to the Task root directory (one directory above the working directory).  There is a maximum size for the list of resource files.  When the max size is exceeded, the request will fail and the response error code will be RequestEntityTooLarge. If this occurs, the collection of ResourceFiles must be reduced in size. This can be achieved using .zip files, Application Packages, or Docker Containers. </summary>
        public IList<ResourceFile> CommonResourceFiles { get; }
    }
}
