// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Compute.Batch
{
    public partial class MultiInstanceSettings : IUtf8JsonSerializable, IJsonModel<MultiInstanceSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MultiInstanceSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MultiInstanceSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MultiInstanceSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MultiInstanceSettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(NumberOfInstances))
            {
                writer.WritePropertyName("numberOfInstances"u8);
                writer.WriteNumberValue(NumberOfInstances.Value);
            }
            writer.WritePropertyName("coordinationCommandLine"u8);
            writer.WriteStringValue(CoordinationCommandLine);
            if (Optional.IsCollectionDefined(CommonResourceFiles))
            {
                writer.WritePropertyName("commonResourceFiles"u8);
                writer.WriteStartArray();
                foreach (var item in CommonResourceFiles)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MultiInstanceSettings IJsonModel<MultiInstanceSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MultiInstanceSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MultiInstanceSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMultiInstanceSettings(document.RootElement, options);
        }

        internal static MultiInstanceSettings DeserializeMultiInstanceSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? numberOfInstances = default;
            string coordinationCommandLine = default;
            IList<ResourceFile> commonResourceFiles = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("numberOfInstances"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    numberOfInstances = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("coordinationCommandLine"u8))
                {
                    coordinationCommandLine = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("commonResourceFiles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResourceFile> array = new List<ResourceFile>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ResourceFile.DeserializeResourceFile(item, options));
                    }
                    commonResourceFiles = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MultiInstanceSettings(numberOfInstances, coordinationCommandLine, commonResourceFiles ?? new ChangeTrackingList<ResourceFile>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MultiInstanceSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MultiInstanceSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MultiInstanceSettings)} does not support writing '{options.Format}' format.");
            }
        }

        MultiInstanceSettings IPersistableModel<MultiInstanceSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MultiInstanceSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMultiInstanceSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MultiInstanceSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MultiInstanceSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MultiInstanceSettings FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMultiInstanceSettings(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
