// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> The file system to mount on each node. </summary>
    public partial class MountConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MountConfiguration"/>. </summary>
        public MountConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MountConfiguration"/>. </summary>
        /// <param name="azureBlobFileSystemConfiguration"> The Azure Storage Container to mount using blob FUSE on each node. This property is mutually exclusive with all other properties. </param>
        /// <param name="nfsMountConfiguration"> The NFS file system to mount on each node. This property is mutually exclusive with all other properties. </param>
        /// <param name="cifsMountConfiguration"> The CIFS/SMB file system to mount on each node. This property is mutually exclusive with all other properties. </param>
        /// <param name="azureFileShareConfiguration"> The Azure File Share to mount on each node. This property is mutually exclusive with all other properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MountConfiguration(AzureBlobFileSystemConfiguration azureBlobFileSystemConfiguration, NfsMountConfiguration nfsMountConfiguration, CifsMountConfiguration cifsMountConfiguration, AzureFileShareConfiguration azureFileShareConfiguration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AzureBlobFileSystemConfiguration = azureBlobFileSystemConfiguration;
            NfsMountConfiguration = nfsMountConfiguration;
            CifsMountConfiguration = cifsMountConfiguration;
            AzureFileShareConfiguration = azureFileShareConfiguration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Azure Storage Container to mount using blob FUSE on each node. This property is mutually exclusive with all other properties. </summary>
        public AzureBlobFileSystemConfiguration AzureBlobFileSystemConfiguration { get; set; }
        /// <summary> The NFS file system to mount on each node. This property is mutually exclusive with all other properties. </summary>
        public NfsMountConfiguration NfsMountConfiguration { get; set; }
        /// <summary> The CIFS/SMB file system to mount on each node. This property is mutually exclusive with all other properties. </summary>
        public CifsMountConfiguration CifsMountConfiguration { get; set; }
        /// <summary> The Azure File Share to mount on each node. This property is mutually exclusive with all other properties. </summary>
        public AzureFileShareConfiguration AzureFileShareConfiguration { get; set; }
    }
}
